/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateChannelRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelName").build()).build();

    private static final SdkField<ChannelStorage> CHANNEL_STORAGE_FIELD = SdkField
            .<ChannelStorage> builder(MarshallingType.SDK_POJO).getter(getter(UpdateChannelRequest::channelStorage))
            .setter(setter(Builder::channelStorage)).constructor(ChannelStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStorage").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).getter(getter(UpdateChannelRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CHANNEL_STORAGE_FIELD, RETENTION_PERIOD_FIELD));

    private final String channelName;

    private final ChannelStorage channelStorage;

    private final RetentionPeriod retentionPeriod;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelStorage = builder.channelStorage;
        this.retentionPeriod = builder.retentionPeriod;
    }

    /**
     * <p>
     * The name of the channel to be updated.
     * </p>
     * 
     * @return The name of the channel to be updated.
     */
    public String channelName() {
        return channelName;
    }

    /**
     * <p>
     * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
     * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
     * </p>
     * 
     * @return Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
     *         not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
     */
    public ChannelStorage channelStorage() {
        return channelStorage;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel. The retention period cannot be updated if the channel's
     * S3 storage is customer-managed.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel. The retention period cannot be updated if the
     *         channel's S3 storage is customer-managed.
     */
    public RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelStorage());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(channelStorage(), other.channelStorage())
                && Objects.equals(retentionPeriod(), other.retentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateChannelRequest").add("ChannelName", channelName()).add("ChannelStorage", channelStorage())
                .add("RetentionPeriod", retentionPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelStorage":
            return Optional.ofNullable(clazz.cast(channelStorage()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * <p>
         * The name of the channel to be updated.
         * </p>
         * 
         * @param channelName
         *        The name of the channel to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
         * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
         * </p>
         * 
         * @param channelStorage
         *        Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage.
         *        If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the
         *        channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelStorage(ChannelStorage channelStorage);

        /**
         * <p>
         * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
         * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelStorage.Builder} avoiding the need to
         * create one manually via {@link ChannelStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #channelStorage(ChannelStorage)}.
         * 
         * @param channelStorage
         *        a consumer that will call methods on {@link ChannelStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelStorage(ChannelStorage)
         */
        default Builder channelStorage(Consumer<ChannelStorage.Builder> channelStorage) {
            return channelStorage(ChannelStorage.builder().applyMutation(channelStorage).build());
        }

        /**
         * <p>
         * How long, in days, message data is kept for the channel. The retention period cannot be updated if the
         * channel's S3 storage is customer-managed.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the channel. The retention period cannot be updated if the
         *        channel's S3 storage is customer-managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the channel. The retention period cannot be updated if the
         * channel's S3 storage is customer-managed.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String channelName;

        private ChannelStorage channelStorage;

        private RetentionPeriod retentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            channelName(model.channelName);
            channelStorage(model.channelStorage);
            retentionPeriod(model.retentionPeriod);
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final ChannelStorage.Builder getChannelStorage() {
            return channelStorage != null ? channelStorage.toBuilder() : null;
        }

        @Override
        public final Builder channelStorage(ChannelStorage channelStorage) {
            this.channelStorage = channelStorage;
            return this;
        }

        public final void setChannelStorage(ChannelStorage.BuilderImpl channelStorage) {
            this.channelStorage = channelStorage != null ? channelStorage.build() : null;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
