/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilesForTargetRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListSecurityProfilesForTargetRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSecurityProfilesForTargetRequest.getter(ListSecurityProfilesForTargetRequest::nextToken)).setter(ListSecurityProfilesForTargetRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListSecurityProfilesForTargetRequest.getter(ListSecurityProfilesForTargetRequest::maxResults)).setter(ListSecurityProfilesForTargetRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListSecurityProfilesForTargetRequest.getter(ListSecurityProfilesForTargetRequest::recursive)).setter(ListSecurityProfilesForTargetRequest.setter(Builder::recursive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recursive").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSecurityProfilesForTargetRequest.getter(ListSecurityProfilesForTargetRequest::securityProfileTargetArn)).setter(ListSecurityProfilesForTargetRequest.setter(Builder::securityProfileTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("securityProfileTargetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RECURSIVE_FIELD, SECURITY_PROFILE_TARGET_ARN_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean recursive;
    private final String securityProfileTargetArn;

    private ListSecurityProfilesForTargetRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
        this.securityProfileTargetArn = builder.securityProfileTargetArn;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Boolean recursive() {
        return this.recursive;
    }

    public String securityProfileTargetArn() {
        return this.securityProfileTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.recursive());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileTargetArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetRequest)) {
            return false;
        }
        ListSecurityProfilesForTargetRequest other = (ListSecurityProfilesForTargetRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.recursive(), other.recursive()) && Objects.equals(this.securityProfileTargetArn(), other.securityProfileTargetArn());
    }

    public String toString() {
        return ToString.builder((String)"ListSecurityProfilesForTargetRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Recursive", (Object)this.recursive()).add("SecurityProfileTargetArn", (Object)this.securityProfileTargetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "recursive": {
                return Optional.ofNullable(clazz.cast(this.recursive()));
            }
            case "securityProfileTargetArn": {
                return Optional.ofNullable(clazz.cast(this.securityProfileTargetArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesForTargetRequest, T> g) {
        return obj -> g.apply((ListSecurityProfilesForTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Boolean recursive;
        private String securityProfileTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.recursive(model.recursive);
            this.securityProfileTargetArn(model.securityProfileTargetArn);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public final String getSecurityProfileTargetArn() {
            return this.securityProfileTargetArn;
        }

        @Override
        public final Builder securityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
            return this;
        }

        public final void setSecurityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecurityProfilesForTargetRequest build() {
            return new ListSecurityProfilesForTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfilesForTargetRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder recursive(Boolean var1);

        public Builder securityProfileTargetArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

