/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PoliciesCopier;
import software.amazon.awssdk.services.iot.model.Policy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListPoliciesResponse> {
    private static final SdkField<List<Policy>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPoliciesResponse.getter(ListPoliciesResponse::policies)).setter(ListPoliciesResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesResponse.getter(ListPoliciesResponse::nextMarker)).setter(ListPoliciesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD, NEXT_MARKER_FIELD));
    private final List<Policy> policies;
    private final String nextMarker;

    private ListPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
        this.nextMarker = builder.nextMarker;
    }

    public List<Policy> policies() {
        return this.policies;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse)((Object)obj);
        return Objects.equals(this.policies(), other.policies()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListPoliciesResponse").add("Policies", this.policies()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesResponse, T> g) {
        return obj -> g.apply((ListPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<Policy> policies = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            super(model);
            this.policies(model.policies);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<Policy.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(Policy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<Policy.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (Policy)((Policy.Builder)Policy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoliciesResponse> {
        public Builder policies(Collection<Policy> var1);

        public Builder policies(Policy ... var1);

        public Builder policies(Consumer<Policy.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

