/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CommandParameterValueNumberRange;
import software.amazon.awssdk.services.iot.model.CommandParameterValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandParameterValueComparisonOperand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandParameterValueComparisonOperand> {
    private static final SdkField<String> NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("number").getter(CommandParameterValueComparisonOperand.getter(CommandParameterValueComparisonOperand::number)).setter(CommandParameterValueComparisonOperand.setter(Builder::number)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()}).build();
    private static final SdkField<List<String>> NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("numbers").getter(CommandParameterValueComparisonOperand.getter(CommandParameterValueComparisonOperand::numbers)).setter(CommandParameterValueComparisonOperand.setter(Builder::numbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("string").getter(CommandParameterValueComparisonOperand.getter(CommandParameterValueComparisonOperand::string)).setter(CommandParameterValueComparisonOperand.setter(Builder::string)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()}).build();
    private static final SdkField<List<String>> STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("strings").getter(CommandParameterValueComparisonOperand.getter(CommandParameterValueComparisonOperand::strings)).setter(CommandParameterValueComparisonOperand.setter(Builder::strings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CommandParameterValueNumberRange> NUMBER_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("numberRange").getter(CommandParameterValueComparisonOperand.getter(CommandParameterValueComparisonOperand::numberRange)).setter(CommandParameterValueComparisonOperand.setter(Builder::numberRange)).constructor(CommandParameterValueNumberRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_FIELD, NUMBERS_FIELD, STRING_FIELD, STRINGS_FIELD, NUMBER_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommandParameterValueComparisonOperand.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String number;
    private final List<String> numbers;
    private final String string;
    private final List<String> strings;
    private final CommandParameterValueNumberRange numberRange;

    private CommandParameterValueComparisonOperand(BuilderImpl builder) {
        this.number = builder.number;
        this.numbers = builder.numbers;
        this.string = builder.string;
        this.strings = builder.strings;
        this.numberRange = builder.numberRange;
    }

    public final String number() {
        return this.number;
    }

    public final boolean hasNumbers() {
        return this.numbers != null && !(this.numbers instanceof SdkAutoConstructList);
    }

    public final List<String> numbers() {
        return this.numbers;
    }

    public final String string() {
        return this.string;
    }

    public final boolean hasStrings() {
        return this.strings != null && !(this.strings instanceof SdkAutoConstructList);
    }

    public final List<String> strings() {
        return this.strings;
    }

    public final CommandParameterValueNumberRange numberRange() {
        return this.numberRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.number());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumbers() ? this.numbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStrings() ? this.strings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandParameterValueComparisonOperand)) {
            return false;
        }
        CommandParameterValueComparisonOperand other = (CommandParameterValueComparisonOperand)obj;
        return Objects.equals(this.number(), other.number()) && this.hasNumbers() == other.hasNumbers() && Objects.equals(this.numbers(), other.numbers()) && Objects.equals(this.string(), other.string()) && this.hasStrings() == other.hasStrings() && Objects.equals(this.strings(), other.strings()) && Objects.equals(this.numberRange(), other.numberRange());
    }

    public final String toString() {
        return ToString.builder((String)"CommandParameterValueComparisonOperand").add("Number", (Object)this.number()).add("Numbers", this.hasNumbers() ? this.numbers() : null).add("String", (Object)this.string()).add("Strings", this.hasStrings() ? this.strings() : null).add("NumberRange", (Object)this.numberRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "number": {
                return Optional.ofNullable(clazz.cast(this.number()));
            }
            case "numbers": {
                return Optional.ofNullable(clazz.cast(this.numbers()));
            }
            case "string": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "strings": {
                return Optional.ofNullable(clazz.cast(this.strings()));
            }
            case "numberRange": {
                return Optional.ofNullable(clazz.cast(this.numberRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", NUMBER_FIELD);
        map.put("numbers", NUMBERS_FIELD);
        map.put("string", STRING_FIELD);
        map.put("strings", STRINGS_FIELD);
        map.put("numberRange", NUMBER_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandParameterValueComparisonOperand, T> g) {
        return obj -> g.apply((CommandParameterValueComparisonOperand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String number;
        private List<String> numbers = DefaultSdkAutoConstructList.getInstance();
        private String string;
        private List<String> strings = DefaultSdkAutoConstructList.getInstance();
        private CommandParameterValueNumberRange numberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandParameterValueComparisonOperand model) {
            this.number(model.number);
            this.numbers(model.numbers);
            this.string(model.string);
            this.strings(model.strings);
            this.numberRange(model.numberRange);
        }

        public final String getNumber() {
            return this.number;
        }

        public final void setNumber(String number) {
            this.number = number;
        }

        @Override
        public final Builder number(String number) {
            this.number = number;
            return this;
        }

        public final Collection<String> getNumbers() {
            if (this.numbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numbers;
        }

        public final void setNumbers(Collection<String> numbers) {
            this.numbers = CommandParameterValueStringListCopier.copy(numbers);
        }

        @Override
        public final Builder numbers(Collection<String> numbers) {
            this.numbers = CommandParameterValueStringListCopier.copy(numbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numbers(String ... numbers) {
            this.numbers(Arrays.asList(numbers));
            return this;
        }

        public final String getString() {
            return this.string;
        }

        public final void setString(String string) {
            this.string = string;
        }

        @Override
        public final Builder string(String string) {
            this.string = string;
            return this;
        }

        public final Collection<String> getStrings() {
            if (this.strings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.strings;
        }

        public final void setStrings(Collection<String> strings) {
            this.strings = CommandParameterValueStringListCopier.copy(strings);
        }

        @Override
        public final Builder strings(Collection<String> strings) {
            this.strings = CommandParameterValueStringListCopier.copy(strings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strings(String ... strings) {
            this.strings(Arrays.asList(strings));
            return this;
        }

        public final CommandParameterValueNumberRange.Builder getNumberRange() {
            return this.numberRange != null ? this.numberRange.toBuilder() : null;
        }

        public final void setNumberRange(CommandParameterValueNumberRange.BuilderImpl numberRange) {
            this.numberRange = numberRange != null ? numberRange.build() : null;
        }

        @Override
        public final Builder numberRange(CommandParameterValueNumberRange numberRange) {
            this.numberRange = numberRange;
            return this;
        }

        public CommandParameterValueComparisonOperand build() {
            return new CommandParameterValueComparisonOperand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandParameterValueComparisonOperand> {
        public Builder number(String var1);

        public Builder numbers(Collection<String> var1);

        public Builder numbers(String ... var1);

        public Builder string(String var1);

        public Builder strings(Collection<String> var1);

        public Builder strings(String ... var1);

        public Builder numberRange(CommandParameterValueNumberRange var1);

        default public Builder numberRange(Consumer<CommandParameterValueNumberRange.Builder> numberRange) {
            return this.numberRange((CommandParameterValueNumberRange)((CommandParameterValueNumberRange.Builder)CommandParameterValueNumberRange.builder().applyMutation(numberRange)).build());
        }
    }
}

