/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditFindingSeverity;
import software.amazon.awssdk.services.iot.model.NonCompliantResource;
import software.amazon.awssdk.services.iot.model.RelatedResource;
import software.amazon.awssdk.services.iot.model.RelatedResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditFinding> {
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingId").getter(AuditFinding.getter(AuditFinding::findingId)).setter(AuditFinding.setter(Builder::findingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(AuditFinding.getter(AuditFinding::taskId)).setter(AuditFinding.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkName").getter(AuditFinding.getter(AuditFinding::checkName)).setter(AuditFinding.setter(Builder::checkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()}).build();
    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("taskStartTime").getter(AuditFinding.getter(AuditFinding::taskStartTime)).setter(AuditFinding.setter(Builder::taskStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build()}).build();
    private static final SdkField<Instant> FINDING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("findingTime").getter(AuditFinding.getter(AuditFinding::findingTime)).setter(AuditFinding.setter(Builder::findingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTime").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(AuditFinding.getter(AuditFinding::severityAsString)).setter(AuditFinding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<NonCompliantResource> NON_COMPLIANT_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nonCompliantResource").getter(AuditFinding.getter(AuditFinding::nonCompliantResource)).setter(AuditFinding.setter(Builder::nonCompliantResource)).constructor(NonCompliantResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantResource").build()}).build();
    private static final SdkField<List<RelatedResource>> RELATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedResources").getter(AuditFinding.getter(AuditFinding::relatedResources)).setter(AuditFinding.setter(Builder::relatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REASON_FOR_NON_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reasonForNonCompliance").getter(AuditFinding.getter(AuditFinding::reasonForNonCompliance)).setter(AuditFinding.setter(Builder::reasonForNonCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonForNonCompliance").build()}).build();
    private static final SdkField<String> REASON_FOR_NON_COMPLIANCE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reasonForNonComplianceCode").getter(AuditFinding.getter(AuditFinding::reasonForNonComplianceCode)).setter(AuditFinding.setter(Builder::reasonForNonComplianceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonForNonComplianceCode").build()}).build();
    private static final SdkField<Boolean> IS_SUPPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSuppressed").getter(AuditFinding.getter(AuditFinding::isSuppressed)).setter(AuditFinding.setter(Builder::isSuppressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSuppressed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ID_FIELD, TASK_ID_FIELD, CHECK_NAME_FIELD, TASK_START_TIME_FIELD, FINDING_TIME_FIELD, SEVERITY_FIELD, NON_COMPLIANT_RESOURCE_FIELD, RELATED_RESOURCES_FIELD, REASON_FOR_NON_COMPLIANCE_FIELD, REASON_FOR_NON_COMPLIANCE_CODE_FIELD, IS_SUPPRESSED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingId;
    private final String taskId;
    private final String checkName;
    private final Instant taskStartTime;
    private final Instant findingTime;
    private final String severity;
    private final NonCompliantResource nonCompliantResource;
    private final List<RelatedResource> relatedResources;
    private final String reasonForNonCompliance;
    private final String reasonForNonComplianceCode;
    private final Boolean isSuppressed;

    private AuditFinding(BuilderImpl builder) {
        this.findingId = builder.findingId;
        this.taskId = builder.taskId;
        this.checkName = builder.checkName;
        this.taskStartTime = builder.taskStartTime;
        this.findingTime = builder.findingTime;
        this.severity = builder.severity;
        this.nonCompliantResource = builder.nonCompliantResource;
        this.relatedResources = builder.relatedResources;
        this.reasonForNonCompliance = builder.reasonForNonCompliance;
        this.reasonForNonComplianceCode = builder.reasonForNonComplianceCode;
        this.isSuppressed = builder.isSuppressed;
    }

    public final String findingId() {
        return this.findingId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String checkName() {
        return this.checkName;
    }

    public final Instant taskStartTime() {
        return this.taskStartTime;
    }

    public final Instant findingTime() {
        return this.findingTime;
    }

    public final AuditFindingSeverity severity() {
        return AuditFindingSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final NonCompliantResource nonCompliantResource() {
        return this.nonCompliantResource;
    }

    public final boolean hasRelatedResources() {
        return this.relatedResources != null && !(this.relatedResources instanceof SdkAutoConstructList);
    }

    public final List<RelatedResource> relatedResources() {
        return this.relatedResources;
    }

    public final String reasonForNonCompliance() {
        return this.reasonForNonCompliance;
    }

    public final String reasonForNonComplianceCode() {
        return this.reasonForNonComplianceCode;
    }

    public final Boolean isSuppressed() {
        return this.isSuppressed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedResources() ? this.relatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonForNonCompliance());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonForNonComplianceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSuppressed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding)obj;
        return Objects.equals(this.findingId(), other.findingId()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.checkName(), other.checkName()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.findingTime(), other.findingTime()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.nonCompliantResource(), other.nonCompliantResource()) && this.hasRelatedResources() == other.hasRelatedResources() && Objects.equals(this.relatedResources(), other.relatedResources()) && Objects.equals(this.reasonForNonCompliance(), other.reasonForNonCompliance()) && Objects.equals(this.reasonForNonComplianceCode(), other.reasonForNonComplianceCode()) && Objects.equals(this.isSuppressed(), other.isSuppressed());
    }

    public final String toString() {
        return ToString.builder((String)"AuditFinding").add("FindingId", (Object)this.findingId()).add("TaskId", (Object)this.taskId()).add("CheckName", (Object)this.checkName()).add("TaskStartTime", (Object)this.taskStartTime()).add("FindingTime", (Object)this.findingTime()).add("Severity", (Object)this.severityAsString()).add("NonCompliantResource", (Object)this.nonCompliantResource()).add("RelatedResources", this.hasRelatedResources() ? this.relatedResources() : null).add("ReasonForNonCompliance", (Object)this.reasonForNonCompliance()).add("ReasonForNonComplianceCode", (Object)this.reasonForNonComplianceCode()).add("IsSuppressed", (Object)this.isSuppressed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingId": {
                return Optional.ofNullable(clazz.cast(this.findingId()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "checkName": {
                return Optional.ofNullable(clazz.cast(this.checkName()));
            }
            case "taskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "findingTime": {
                return Optional.ofNullable(clazz.cast(this.findingTime()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "nonCompliantResource": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResource()));
            }
            case "relatedResources": {
                return Optional.ofNullable(clazz.cast(this.relatedResources()));
            }
            case "reasonForNonCompliance": {
                return Optional.ofNullable(clazz.cast(this.reasonForNonCompliance()));
            }
            case "reasonForNonComplianceCode": {
                return Optional.ofNullable(clazz.cast(this.reasonForNonComplianceCode()));
            }
            case "isSuppressed": {
                return Optional.ofNullable(clazz.cast(this.isSuppressed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingId", FINDING_ID_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("checkName", CHECK_NAME_FIELD);
        map.put("taskStartTime", TASK_START_TIME_FIELD);
        map.put("findingTime", FINDING_TIME_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("nonCompliantResource", NON_COMPLIANT_RESOURCE_FIELD);
        map.put("relatedResources", RELATED_RESOURCES_FIELD);
        map.put("reasonForNonCompliance", REASON_FOR_NON_COMPLIANCE_FIELD);
        map.put("reasonForNonComplianceCode", REASON_FOR_NON_COMPLIANCE_CODE_FIELD);
        map.put("isSuppressed", IS_SUPPRESSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditFinding, T> g) {
        return obj -> g.apply((AuditFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingId;
        private String taskId;
        private String checkName;
        private Instant taskStartTime;
        private Instant findingTime;
        private String severity;
        private NonCompliantResource nonCompliantResource;
        private List<RelatedResource> relatedResources = DefaultSdkAutoConstructList.getInstance();
        private String reasonForNonCompliance;
        private String reasonForNonComplianceCode;
        private Boolean isSuppressed;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditFinding model) {
            this.findingId(model.findingId);
            this.taskId(model.taskId);
            this.checkName(model.checkName);
            this.taskStartTime(model.taskStartTime);
            this.findingTime(model.findingTime);
            this.severity(model.severity);
            this.nonCompliantResource(model.nonCompliantResource);
            this.relatedResources(model.relatedResources);
            this.reasonForNonCompliance(model.reasonForNonCompliance);
            this.reasonForNonComplianceCode(model.reasonForNonComplianceCode);
            this.isSuppressed(model.isSuppressed);
        }

        public final String getFindingId() {
            return this.findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getCheckName() {
            return this.checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final Instant getFindingTime() {
            return this.findingTime;
        }

        public final void setFindingTime(Instant findingTime) {
            this.findingTime = findingTime;
        }

        @Override
        public final Builder findingTime(Instant findingTime) {
            this.findingTime = findingTime;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AuditFindingSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final NonCompliantResource.Builder getNonCompliantResource() {
            return this.nonCompliantResource != null ? this.nonCompliantResource.toBuilder() : null;
        }

        public final void setNonCompliantResource(NonCompliantResource.BuilderImpl nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource != null ? nonCompliantResource.build() : null;
        }

        @Override
        public final Builder nonCompliantResource(NonCompliantResource nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource;
            return this;
        }

        public final List<RelatedResource.Builder> getRelatedResources() {
            List<RelatedResource.Builder> result = RelatedResourcesCopier.copyToBuilder(this.relatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedResources(Collection<RelatedResource.BuilderImpl> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public final Builder relatedResources(Collection<RelatedResource> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(RelatedResource ... relatedResources) {
            this.relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<RelatedResource.Builder> ... relatedResources) {
            this.relatedResources(Stream.of(relatedResources).map(c -> (RelatedResource)((RelatedResource.Builder)RelatedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReasonForNonCompliance() {
            return this.reasonForNonCompliance;
        }

        public final void setReasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
        }

        @Override
        public final Builder reasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
            return this;
        }

        public final String getReasonForNonComplianceCode() {
            return this.reasonForNonComplianceCode;
        }

        public final void setReasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
        }

        @Override
        public final Builder reasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
            return this;
        }

        public final Boolean getIsSuppressed() {
            return this.isSuppressed;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public AuditFinding build() {
            return new AuditFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditFinding> {
        public Builder findingId(String var1);

        public Builder taskId(String var1);

        public Builder checkName(String var1);

        public Builder taskStartTime(Instant var1);

        public Builder findingTime(Instant var1);

        public Builder severity(String var1);

        public Builder severity(AuditFindingSeverity var1);

        public Builder nonCompliantResource(NonCompliantResource var1);

        default public Builder nonCompliantResource(Consumer<NonCompliantResource.Builder> nonCompliantResource) {
            return this.nonCompliantResource((NonCompliantResource)((NonCompliantResource.Builder)NonCompliantResource.builder().applyMutation(nonCompliantResource)).build());
        }

        public Builder relatedResources(Collection<RelatedResource> var1);

        public Builder relatedResources(RelatedResource ... var1);

        public Builder relatedResources(Consumer<RelatedResource.Builder> ... var1);

        public Builder reasonForNonCompliance(String var1);

        public Builder reasonForNonComplianceCode(String var1);

        public Builder isSuppressed(Boolean var1);
    }
}

