/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateListingCopier;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisioningTemplatesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListProvisioningTemplatesResponse> {
    private static final SdkField<List<ProvisioningTemplateSummary>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templates").getter(ListProvisioningTemplatesResponse.getter(ListProvisioningTemplatesResponse::templates)).setter(ListProvisioningTemplatesResponse.setter(Builder::templates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProvisioningTemplatesResponse.getter(ListProvisioningTemplatesResponse::nextToken)).setter(ListProvisioningTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProvisioningTemplatesResponse.memberNameToFieldInitializer();
    private final List<ProvisioningTemplateSummary> templates;
    private final String nextToken;

    private ListProvisioningTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templates = builder.templates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningTemplateSummary> templates() {
        return this.templates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningTemplatesResponse)) {
            return false;
        }
        ListProvisioningTemplatesResponse other = (ListProvisioningTemplatesResponse)((Object)obj);
        return this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templates(), other.templates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProvisioningTemplatesResponse").add("Templates", this.hasTemplates() ? this.templates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templates": {
                return Optional.ofNullable(clazz.cast(this.templates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templates", TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningTemplatesResponse, T> g) {
        return obj -> g.apply((ListProvisioningTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningTemplateSummary> templates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningTemplatesResponse model) {
            super(model);
            this.templates(model.templates);
            this.nextToken(model.nextToken);
        }

        public final List<ProvisioningTemplateSummary.Builder> getTemplates() {
            List<ProvisioningTemplateSummary.Builder> result = ProvisioningTemplateListingCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<ProvisioningTemplateSummary.BuilderImpl> templates) {
            this.templates = ProvisioningTemplateListingCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<ProvisioningTemplateSummary> templates) {
            this.templates = ProvisioningTemplateListingCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(ProvisioningTemplateSummary ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<ProvisioningTemplateSummary.Builder> ... templates) {
            this.templates(Stream.of(templates).map(c -> (ProvisioningTemplateSummary)((ProvisioningTemplateSummary.Builder)ProvisioningTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProvisioningTemplatesResponse build() {
            return new ListProvisioningTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisioningTemplatesResponse> {
        public Builder templates(Collection<ProvisioningTemplateSummary> var1);

        public Builder templates(ProvisioningTemplateSummary ... var1);

        public Builder templates(Consumer<ProvisioningTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

