/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AggregationType;
import software.amazon.awssdk.services.iot.model.FleetMetricUnit;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFleetMetricRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateFleetMetricRequest> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::metricName)).setter(UpdateFleetMetricRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("metricName").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::queryString)).setter(UpdateFleetMetricRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<AggregationType> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationType").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::aggregationType)).setter(UpdateFleetMetricRequest.setter(Builder::aggregationType)).constructor(AggregationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("period").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::period)).setter(UpdateFleetMetricRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationField").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::aggregationField)).setter(UpdateFleetMetricRequest.setter(Builder::aggregationField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::description)).setter(UpdateFleetMetricRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryVersion").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::queryVersion)).setter(UpdateFleetMetricRequest.setter(Builder::queryVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::indexName)).setter(UpdateFleetMetricRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::unitAsString)).setter(UpdateFleetMetricRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expectedVersion").getter(UpdateFleetMetricRequest.getter(UpdateFleetMetricRequest::expectedVersion)).setter(UpdateFleetMetricRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, QUERY_STRING_FIELD, AGGREGATION_TYPE_FIELD, PERIOD_FIELD, AGGREGATION_FIELD_FIELD, DESCRIPTION_FIELD, QUERY_VERSION_FIELD, INDEX_NAME_FIELD, UNIT_FIELD, EXPECTED_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFleetMetricRequest.memberNameToFieldInitializer();
    private final String metricName;
    private final String queryString;
    private final AggregationType aggregationType;
    private final Integer period;
    private final String aggregationField;
    private final String description;
    private final String queryVersion;
    private final String indexName;
    private final String unit;
    private final Long expectedVersion;

    private UpdateFleetMetricRequest(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.queryString = builder.queryString;
        this.aggregationType = builder.aggregationType;
        this.period = builder.period;
        this.aggregationField = builder.aggregationField;
        this.description = builder.description;
        this.queryVersion = builder.queryVersion;
        this.indexName = builder.indexName;
        this.unit = builder.unit;
        this.expectedVersion = builder.expectedVersion;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final AggregationType aggregationType() {
        return this.aggregationType;
    }

    public final Integer period() {
        return this.period;
    }

    public final String aggregationField() {
        return this.aggregationField;
    }

    public final String description() {
        return this.description;
    }

    public final String queryVersion() {
        return this.queryVersion;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final FleetMetricUnit unit() {
        return FleetMetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Long expectedVersion() {
        return this.expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetMetricRequest)) {
            return false;
        }
        UpdateFleetMetricRequest other = (UpdateFleetMetricRequest)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.aggregationType(), other.aggregationType()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.aggregationField(), other.aggregationField()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.queryVersion(), other.queryVersion()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.expectedVersion(), other.expectedVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFleetMetricRequest").add("MetricName", (Object)this.metricName()).add("QueryString", (Object)this.queryString()).add("AggregationType", (Object)this.aggregationType()).add("Period", (Object)this.period()).add("AggregationField", (Object)this.aggregationField()).add("Description", (Object)this.description()).add("QueryVersion", (Object)this.queryVersion()).add("IndexName", (Object)this.indexName()).add("Unit", (Object)this.unitAsString()).add("ExpectedVersion", (Object)this.expectedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationType()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "aggregationField": {
                return Optional.ofNullable(clazz.cast(this.aggregationField()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("aggregationType", AGGREGATION_TYPE_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("aggregationField", AGGREGATION_FIELD_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("queryVersion", QUERY_VERSION_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("expectedVersion", EXPECTED_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetMetricRequest, T> g) {
        return obj -> g.apply((UpdateFleetMetricRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String metricName;
        private String queryString;
        private AggregationType aggregationType;
        private Integer period;
        private String aggregationField;
        private String description;
        private String queryVersion;
        private String indexName;
        private String unit;
        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetMetricRequest model) {
            super(model);
            this.metricName(model.metricName);
            this.queryString(model.queryString);
            this.aggregationType(model.aggregationType);
            this.period(model.period);
            this.aggregationField(model.aggregationField);
            this.description(model.description);
            this.queryVersion(model.queryVersion);
            this.indexName(model.indexName);
            this.unit(model.unit);
            this.expectedVersion(model.expectedVersion);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final AggregationType.Builder getAggregationType() {
            return this.aggregationType != null ? this.aggregationType.toBuilder() : null;
        }

        public final void setAggregationType(AggregationType.BuilderImpl aggregationType) {
            this.aggregationType = aggregationType != null ? aggregationType.build() : null;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAggregationField() {
            return this.aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(FleetMetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetMetricRequest build() {
            return new UpdateFleetMetricRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFleetMetricRequest> {
        public Builder metricName(String var1);

        public Builder queryString(String var1);

        public Builder aggregationType(AggregationType var1);

        default public Builder aggregationType(Consumer<AggregationType.Builder> aggregationType) {
            return this.aggregationType((AggregationType)((AggregationType.Builder)AggregationType.builder().applyMutation(aggregationType)).build());
        }

        public Builder period(Integer var1);

        public Builder aggregationField(String var1);

        public Builder description(String var1);

        public Builder queryVersion(String var1);

        public Builder indexName(String var1);

        public Builder unit(String var1);

        public Builder unit(FleetMetricUnit var1);

        public Builder expectedVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

