/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingDocument;
import software.amazon.awssdk.services.iot.model.ThingDocumentListCopier;
import software.amazon.awssdk.services.iot.model.ThingGroupDocument;
import software.amazon.awssdk.services.iot.model.ThingGroupDocumentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchIndexResponse
extends IotResponse
implements ToCopyableBuilder<Builder, SearchIndexResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchIndexResponse.getter(SearchIndexResponse::nextToken)).setter(SearchIndexResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ThingDocument>> THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("things").getter(SearchIndexResponse.getter(SearchIndexResponse::things)).setter(SearchIndexResponse.setter(Builder::things)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThingDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ThingGroupDocument>> THING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroups").getter(SearchIndexResponse.getter(SearchIndexResponse::thingGroups)).setter(SearchIndexResponse.setter(Builder::thingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThingGroupDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, THINGS_FIELD, THING_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchIndexResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ThingDocument> things;
    private final List<ThingGroupDocument> thingGroups;

    private SearchIndexResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.things = builder.things;
        this.thingGroups = builder.thingGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasThings() {
        return this.things != null && !(this.things instanceof SdkAutoConstructList);
    }

    public final List<ThingDocument> things() {
        return this.things;
    }

    public final boolean hasThingGroups() {
        return this.thingGroups != null && !(this.thingGroups instanceof SdkAutoConstructList);
    }

    public final List<ThingGroupDocument> thingGroups() {
        return this.thingGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThings() ? this.things() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroups() ? this.thingGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexResponse)) {
            return false;
        }
        SearchIndexResponse other = (SearchIndexResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasThings() == other.hasThings() && Objects.equals(this.things(), other.things()) && this.hasThingGroups() == other.hasThingGroups() && Objects.equals(this.thingGroups(), other.thingGroups());
    }

    public final String toString() {
        return ToString.builder((String)"SearchIndexResponse").add("NextToken", (Object)this.nextToken()).add("Things", this.hasThings() ? this.things() : null).add("ThingGroups", this.hasThingGroups() ? this.thingGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "things": {
                return Optional.ofNullable(clazz.cast(this.things()));
            }
            case "thingGroups": {
                return Optional.ofNullable(clazz.cast(this.thingGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("things", THINGS_FIELD);
        map.put("thingGroups", THING_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchIndexResponse, T> g) {
        return obj -> g.apply((SearchIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ThingDocument> things = DefaultSdkAutoConstructList.getInstance();
        private List<ThingGroupDocument> thingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchIndexResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.things(model.things);
            this.thingGroups(model.thingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ThingDocument.Builder> getThings() {
            List<ThingDocument.Builder> result = ThingDocumentListCopier.copyToBuilder(this.things);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThings(Collection<ThingDocument.BuilderImpl> things) {
            this.things = ThingDocumentListCopier.copyFromBuilder(things);
        }

        @Override
        public final Builder things(Collection<ThingDocument> things) {
            this.things = ThingDocumentListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingDocument ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<ThingDocument.Builder> ... things) {
            this.things(Stream.of(things).map(c -> (ThingDocument)((ThingDocument.Builder)ThingDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThingGroupDocument.Builder> getThingGroups() {
            List<ThingGroupDocument.Builder> result = ThingGroupDocumentListCopier.copyToBuilder(this.thingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingGroups(Collection<ThingGroupDocument.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copyFromBuilder(thingGroups);
        }

        @Override
        public final Builder thingGroups(Collection<ThingGroupDocument> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(ThingGroupDocument ... thingGroups) {
            this.thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<ThingGroupDocument.Builder> ... thingGroups) {
            this.thingGroups(Stream.of(thingGroups).map(c -> (ThingGroupDocument)((ThingGroupDocument.Builder)ThingGroupDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchIndexResponse build() {
            return new SearchIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchIndexResponse> {
        public Builder nextToken(String var1);

        public Builder things(Collection<ThingDocument> var1);

        public Builder things(ThingDocument ... var1);

        public Builder things(Consumer<ThingDocument.Builder> ... var1);

        public Builder thingGroups(Collection<ThingGroupDocument> var1);

        public Builder thingGroups(ThingGroupDocument ... var1);

        public Builder thingGroups(Consumer<ThingGroupDocument.Builder> ... var1);
    }
}

