/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CertificateProviderAccountDefaultForOperationsCopier;
import software.amazon.awssdk.services.iot.model.CertificateProviderOperation;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateProviderRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateCertificateProviderRequest> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProviderName").getter(CreateCertificateProviderRequest.getter(CreateCertificateProviderRequest::certificateProviderName)).setter(CreateCertificateProviderRequest.setter(Builder::certificateProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateProviderName").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaFunctionArn").getter(CreateCertificateProviderRequest.getter(CreateCertificateProviderRequest::lambdaFunctionArn)).setter(CreateCertificateProviderRequest.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountDefaultForOperations").getter(CreateCertificateProviderRequest.getter(CreateCertificateProviderRequest::accountDefaultForOperationsAsStrings)).setter(CreateCertificateProviderRequest.setter(Builder::accountDefaultForOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDefaultForOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCertificateProviderRequest.getter(CreateCertificateProviderRequest::clientToken)).setter(CreateCertificateProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCertificateProviderRequest.getter(CreateCertificateProviderRequest::tags)).setter(CreateCertificateProviderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PROVIDER_NAME_FIELD, LAMBDA_FUNCTION_ARN_FIELD, ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCertificateProviderRequest.memberNameToFieldInitializer();
    private final String certificateProviderName;
    private final String lambdaFunctionArn;
    private final List<String> accountDefaultForOperations;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateCertificateProviderRequest(BuilderImpl builder) {
        super(builder);
        this.certificateProviderName = builder.certificateProviderName;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.accountDefaultForOperations = builder.accountDefaultForOperations;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String certificateProviderName() {
        return this.certificateProviderName;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final List<CertificateProviderOperation> accountDefaultForOperations() {
        return CertificateProviderAccountDefaultForOperationsCopier.copyStringToEnum(this.accountDefaultForOperations);
    }

    public final boolean hasAccountDefaultForOperations() {
        return this.accountDefaultForOperations != null && !(this.accountDefaultForOperations instanceof SdkAutoConstructList);
    }

    public final List<String> accountDefaultForOperationsAsStrings() {
        return this.accountDefaultForOperations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateProviderRequest)) {
            return false;
        }
        CreateCertificateProviderRequest other = (CreateCertificateProviderRequest)((Object)obj);
        return Objects.equals(this.certificateProviderName(), other.certificateProviderName()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && this.hasAccountDefaultForOperations() == other.hasAccountDefaultForOperations() && Objects.equals(this.accountDefaultForOperationsAsStrings(), other.accountDefaultForOperationsAsStrings()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCertificateProviderRequest").add("CertificateProviderName", (Object)this.certificateProviderName()).add("LambdaFunctionArn", (Object)this.lambdaFunctionArn()).add("AccountDefaultForOperations", this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateProviderName": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderName()));
            }
            case "lambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "accountDefaultForOperations": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultForOperationsAsStrings()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certificateProviderName", CERTIFICATE_PROVIDER_NAME_FIELD);
        map.put("lambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        map.put("accountDefaultForOperations", ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateProviderRequest, T> g) {
        return obj -> g.apply((CreateCertificateProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateProviderName;
        private String lambdaFunctionArn;
        private List<String> accountDefaultForOperations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateProviderRequest model) {
            super(model);
            this.certificateProviderName(model.certificateProviderName);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.accountDefaultForOperationsWithStrings(model.accountDefaultForOperations);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getCertificateProviderName() {
            return this.certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getAccountDefaultForOperations() {
            if (this.accountDefaultForOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountDefaultForOperations;
        }

        public final void setAccountDefaultForOperations(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
        }

        @Override
        public final Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperationsWithStrings(String ... accountDefaultForOperations) {
            this.accountDefaultForOperationsWithStrings(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public final Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copyEnumToString(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperations(CertificateProviderOperation ... accountDefaultForOperations) {
            this.accountDefaultForOperations(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateProviderRequest build() {
            return new CreateCertificateProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateProviderRequest> {
        public Builder certificateProviderName(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder accountDefaultForOperationsWithStrings(Collection<String> var1);

        public Builder accountDefaultForOperationsWithStrings(String ... var1);

        public Builder accountDefaultForOperations(Collection<CertificateProviderOperation> var1);

        public Builder accountDefaultForOperations(CertificateProviderOperation ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

