/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditFinding;
import software.amazon.awssdk.services.iot.model.AuditFindingsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditFindingsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuditFindingsResponse> {
    private static final SdkField<List<AuditFinding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findings").getter(ListAuditFindingsResponse.getter(ListAuditFindingsResponse::findings)).setter(ListAuditFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditFindingsResponse.getter(ListAuditFindingsResponse::nextToken)).setter(ListAuditFindingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAuditFindingsResponse.memberNameToFieldInitializer();
    private final List<AuditFinding> findings;
    private final String nextToken;

    private ListAuditFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<AuditFinding> findings() {
        return this.findings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsResponse)) {
            return false;
        }
        ListAuditFindingsResponse other = (ListAuditFindingsResponse)((Object)obj);
        return this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditFindingsResponse").add("Findings", this.hasFindings() ? this.findings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findings", FINDINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsResponse, T> g) {
        return obj -> g.apply((ListAuditFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuditFinding> findings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsResponse model) {
            super(model);
            this.findings(model.findings);
            this.nextToken(model.nextToken);
        }

        public final List<AuditFinding.Builder> getFindings() {
            List<AuditFinding.Builder> result = AuditFindingsCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<AuditFinding.BuilderImpl> findings) {
            this.findings = AuditFindingsCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<AuditFinding> findings) {
            this.findings = AuditFindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(AuditFinding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<AuditFinding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (AuditFinding)((AuditFinding.Builder)AuditFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditFindingsResponse build() {
            return new ListAuditFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditFindingsResponse> {
        public Builder findings(Collection<AuditFinding> var1);

        public Builder findings(AuditFinding ... var1);

        public Builder findings(Consumer<AuditFinding.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

