/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BehaviorModelTrainingSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BehaviorModelTrainingSummary> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::securityProfileName)).setter(BehaviorModelTrainingSummary.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> BEHAVIOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behaviorName").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::behaviorName)).setter(BehaviorModelTrainingSummary.setter(Builder::behaviorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviorName").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_COLLECTION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("trainingDataCollectionStartDate").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::trainingDataCollectionStartDate)).setter(BehaviorModelTrainingSummary.setter(Builder::trainingDataCollectionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataCollectionStartDate").build()}).build();
    private static final SdkField<String> MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelStatus").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::modelStatusAsString)).setter(BehaviorModelTrainingSummary.setter(Builder::modelStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelStatus").build()}).build();
    private static final SdkField<Double> DATAPOINTS_COLLECTION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("datapointsCollectionPercentage").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::datapointsCollectionPercentage)).setter(BehaviorModelTrainingSummary.setter(Builder::datapointsCollectionPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsCollectionPercentage").build()}).build();
    private static final SdkField<Instant> LAST_MODEL_REFRESH_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModelRefreshDate").getter(BehaviorModelTrainingSummary.getter(BehaviorModelTrainingSummary::lastModelRefreshDate)).setter(BehaviorModelTrainingSummary.setter(Builder::lastModelRefreshDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModelRefreshDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_NAME_FIELD, TRAINING_DATA_COLLECTION_START_DATE_FIELD, MODEL_STATUS_FIELD, DATAPOINTS_COLLECTION_PERCENTAGE_FIELD, LAST_MODEL_REFRESH_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BehaviorModelTrainingSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String securityProfileName;
    private final String behaviorName;
    private final Instant trainingDataCollectionStartDate;
    private final String modelStatus;
    private final Double datapointsCollectionPercentage;
    private final Instant lastModelRefreshDate;

    private BehaviorModelTrainingSummary(BuilderImpl builder) {
        this.securityProfileName = builder.securityProfileName;
        this.behaviorName = builder.behaviorName;
        this.trainingDataCollectionStartDate = builder.trainingDataCollectionStartDate;
        this.modelStatus = builder.modelStatus;
        this.datapointsCollectionPercentage = builder.datapointsCollectionPercentage;
        this.lastModelRefreshDate = builder.lastModelRefreshDate;
    }

    public final String securityProfileName() {
        return this.securityProfileName;
    }

    public final String behaviorName() {
        return this.behaviorName;
    }

    public final Instant trainingDataCollectionStartDate() {
        return this.trainingDataCollectionStartDate;
    }

    public final ModelStatus modelStatus() {
        return ModelStatus.fromValue(this.modelStatus);
    }

    public final String modelStatusAsString() {
        return this.modelStatus;
    }

    public final Double datapointsCollectionPercentage() {
        return this.datapointsCollectionPercentage;
    }

    public final Instant lastModelRefreshDate() {
        return this.lastModelRefreshDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataCollectionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsCollectionPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModelRefreshDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BehaviorModelTrainingSummary)) {
            return false;
        }
        BehaviorModelTrainingSummary other = (BehaviorModelTrainingSummary)obj;
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behaviorName(), other.behaviorName()) && Objects.equals(this.trainingDataCollectionStartDate(), other.trainingDataCollectionStartDate()) && Objects.equals(this.modelStatusAsString(), other.modelStatusAsString()) && Objects.equals(this.datapointsCollectionPercentage(), other.datapointsCollectionPercentage()) && Objects.equals(this.lastModelRefreshDate(), other.lastModelRefreshDate());
    }

    public final String toString() {
        return ToString.builder((String)"BehaviorModelTrainingSummary").add("SecurityProfileName", (Object)this.securityProfileName()).add("BehaviorName", (Object)this.behaviorName()).add("TrainingDataCollectionStartDate", (Object)this.trainingDataCollectionStartDate()).add("ModelStatus", (Object)this.modelStatusAsString()).add("DatapointsCollectionPercentage", (Object)this.datapointsCollectionPercentage()).add("LastModelRefreshDate", (Object)this.lastModelRefreshDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behaviorName": {
                return Optional.ofNullable(clazz.cast(this.behaviorName()));
            }
            case "trainingDataCollectionStartDate": {
                return Optional.ofNullable(clazz.cast(this.trainingDataCollectionStartDate()));
            }
            case "modelStatus": {
                return Optional.ofNullable(clazz.cast(this.modelStatusAsString()));
            }
            case "datapointsCollectionPercentage": {
                return Optional.ofNullable(clazz.cast(this.datapointsCollectionPercentage()));
            }
            case "lastModelRefreshDate": {
                return Optional.ofNullable(clazz.cast(this.lastModelRefreshDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("behaviorName", BEHAVIOR_NAME_FIELD);
        map.put("trainingDataCollectionStartDate", TRAINING_DATA_COLLECTION_START_DATE_FIELD);
        map.put("modelStatus", MODEL_STATUS_FIELD);
        map.put("datapointsCollectionPercentage", DATAPOINTS_COLLECTION_PERCENTAGE_FIELD);
        map.put("lastModelRefreshDate", LAST_MODEL_REFRESH_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BehaviorModelTrainingSummary, T> g) {
        return obj -> g.apply((BehaviorModelTrainingSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String behaviorName;
        private Instant trainingDataCollectionStartDate;
        private String modelStatus;
        private Double datapointsCollectionPercentage;
        private Instant lastModelRefreshDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BehaviorModelTrainingSummary model) {
            this.securityProfileName(model.securityProfileName);
            this.behaviorName(model.behaviorName);
            this.trainingDataCollectionStartDate(model.trainingDataCollectionStartDate);
            this.modelStatus(model.modelStatus);
            this.datapointsCollectionPercentage(model.datapointsCollectionPercentage);
            this.lastModelRefreshDate(model.lastModelRefreshDate);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getBehaviorName() {
            return this.behaviorName;
        }

        public final void setBehaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
        }

        @Override
        public final Builder behaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
            return this;
        }

        public final Instant getTrainingDataCollectionStartDate() {
            return this.trainingDataCollectionStartDate;
        }

        public final void setTrainingDataCollectionStartDate(Instant trainingDataCollectionStartDate) {
            this.trainingDataCollectionStartDate = trainingDataCollectionStartDate;
        }

        @Override
        public final Builder trainingDataCollectionStartDate(Instant trainingDataCollectionStartDate) {
            this.trainingDataCollectionStartDate = trainingDataCollectionStartDate;
            return this;
        }

        public final String getModelStatus() {
            return this.modelStatus;
        }

        public final void setModelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
        }

        @Override
        public final Builder modelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
            return this;
        }

        @Override
        public final Builder modelStatus(ModelStatus modelStatus) {
            this.modelStatus(modelStatus == null ? null : modelStatus.toString());
            return this;
        }

        public final Double getDatapointsCollectionPercentage() {
            return this.datapointsCollectionPercentage;
        }

        public final void setDatapointsCollectionPercentage(Double datapointsCollectionPercentage) {
            this.datapointsCollectionPercentage = datapointsCollectionPercentage;
        }

        @Override
        public final Builder datapointsCollectionPercentage(Double datapointsCollectionPercentage) {
            this.datapointsCollectionPercentage = datapointsCollectionPercentage;
            return this;
        }

        public final Instant getLastModelRefreshDate() {
            return this.lastModelRefreshDate;
        }

        public final void setLastModelRefreshDate(Instant lastModelRefreshDate) {
            this.lastModelRefreshDate = lastModelRefreshDate;
        }

        @Override
        public final Builder lastModelRefreshDate(Instant lastModelRefreshDate) {
            this.lastModelRefreshDate = lastModelRefreshDate;
            return this;
        }

        public BehaviorModelTrainingSummary build() {
            return new BehaviorModelTrainingSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BehaviorModelTrainingSummary> {
        public Builder securityProfileName(String var1);

        public Builder behaviorName(String var1);

        public Builder trainingDataCollectionStartDate(Instant var1);

        public Builder modelStatus(String var1);

        public Builder modelStatus(ModelStatus var1);

        public Builder datapointsCollectionPercentage(Double var1);

        public Builder lastModelRefreshDate(Instant var1);
    }
}

