/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ProvisioningHook;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningTemplateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateProvisioningTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::templateName)).setter(CreateProvisioningTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::description)).setter(CreateProvisioningTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateBody").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::templateBody)).setter(CreateProvisioningTemplateRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::enabled)).setter(CreateProvisioningTemplateRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioningRoleArn").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::provisioningRoleArn)).setter(CreateProvisioningTemplateRequest.setter(Builder::provisioningRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()}).build();
    private static final SdkField<ProvisioningHook> PRE_PROVISIONING_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preProvisioningHook").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::preProvisioningHook)).setter(CreateProvisioningTemplateRequest.setter(Builder::preProvisioningHook)).constructor(ProvisioningHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProvisioningHook").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::tags)).setter(CreateProvisioningTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateProvisioningTemplateRequest.getter(CreateProvisioningTemplateRequest::typeAsString)).setter(CreateProvisioningTemplateRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_BODY_FIELD, ENABLED_FIELD, PROVISIONING_ROLE_ARN_FIELD, PRE_PROVISIONING_HOOK_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("templateName", TEMPLATE_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("templateBody", TEMPLATE_BODY_FIELD);
            this.put("enabled", ENABLED_FIELD);
            this.put("provisioningRoleArn", PROVISIONING_ROLE_ARN_FIELD);
            this.put("preProvisioningHook", PRE_PROVISIONING_HOOK_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private final String templateName;
    private final String description;
    private final String templateBody;
    private final Boolean enabled;
    private final String provisioningRoleArn;
    private final ProvisioningHook preProvisioningHook;
    private final List<Tag> tags;
    private final String type;

    private CreateProvisioningTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.enabled = builder.enabled;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.preProvisioningHook = builder.preProvisioningHook;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final ProvisioningHook preProvisioningHook() {
        return this.preProvisioningHook;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final TemplateType type() {
        return TemplateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.preProvisioningHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningTemplateRequest)) {
            return false;
        }
        CreateProvisioningTemplateRequest other = (CreateProvisioningTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && Objects.equals(this.preProvisioningHook(), other.preProvisioningHook()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisioningTemplateRequest").add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("TemplateBody", (Object)this.templateBody()).add("Enabled", (Object)this.enabled()).add("ProvisioningRoleArn", (Object)this.provisioningRoleArn()).add("PreProvisioningHook", (Object)this.preProvisioningHook()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "preProvisioningHook": {
                return Optional.ofNullable(clazz.cast(this.preProvisioningHook()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningTemplateRequest, T> g) {
        return obj -> g.apply((CreateProvisioningTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private String description;
        private String templateBody;
        private Boolean enabled;
        private String provisioningRoleArn;
        private ProvisioningHook preProvisioningHook;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.description(model.description);
            this.templateBody(model.templateBody);
            this.enabled(model.enabled);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.preProvisioningHook(model.preProvisioningHook);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final ProvisioningHook.Builder getPreProvisioningHook() {
            return this.preProvisioningHook != null ? this.preProvisioningHook.toBuilder() : null;
        }

        public final void setPreProvisioningHook(ProvisioningHook.BuilderImpl preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook != null ? preProvisioningHook.build() : null;
        }

        @Override
        public final Builder preProvisioningHook(ProvisioningHook preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TemplateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisioningTemplateRequest build() {
            return new CreateProvisioningTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningTemplateRequest> {
        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder templateBody(String var1);

        public Builder enabled(Boolean var1);

        public Builder provisioningRoleArn(String var1);

        public Builder preProvisioningHook(ProvisioningHook var1);

        default public Builder preProvisioningHook(Consumer<ProvisioningHook.Builder> preProvisioningHook) {
            return this.preProvisioningHook((ProvisioningHook)((ProvisioningHook.Builder)ProvisioningHook.builder().applyMutation(preProvisioningHook)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(TemplateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

