/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CertificateProviderSummary;
import software.amazon.awssdk.services.iot.model.CertificateProvidersCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificateProvidersResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCertificateProvidersResponse> {
    private static final SdkField<List<CertificateProviderSummary>> CERTIFICATE_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificateProviders").getter(ListCertificateProvidersResponse.getter(ListCertificateProvidersResponse::certificateProviders)).setter(ListCertificateProvidersResponse.setter(Builder::certificateProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateProviderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCertificateProvidersResponse.getter(ListCertificateProvidersResponse::nextToken)).setter(ListCertificateProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateProviders", CERTIFICATE_PROVIDERS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CertificateProviderSummary> certificateProviders;
    private final String nextToken;

    private ListCertificateProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.certificateProviders = builder.certificateProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCertificateProviders() {
        return this.certificateProviders != null && !(this.certificateProviders instanceof SdkAutoConstructList);
    }

    public final List<CertificateProviderSummary> certificateProviders() {
        return this.certificateProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateProviders() ? this.certificateProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateProvidersResponse)) {
            return false;
        }
        ListCertificateProvidersResponse other = (ListCertificateProvidersResponse)((Object)obj);
        return this.hasCertificateProviders() == other.hasCertificateProviders() && Objects.equals(this.certificateProviders(), other.certificateProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCertificateProvidersResponse").add("CertificateProviders", this.hasCertificateProviders() ? this.certificateProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateProviders": {
                return Optional.ofNullable(clazz.cast(this.certificateProviders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateProvidersResponse, T> g) {
        return obj -> g.apply((ListCertificateProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<CertificateProviderSummary> certificateProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateProvidersResponse model) {
            super(model);
            this.certificateProviders(model.certificateProviders);
            this.nextToken(model.nextToken);
        }

        public final List<CertificateProviderSummary.Builder> getCertificateProviders() {
            List<CertificateProviderSummary.Builder> result = CertificateProvidersCopier.copyToBuilder(this.certificateProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateProviders(Collection<CertificateProviderSummary.BuilderImpl> certificateProviders) {
            this.certificateProviders = CertificateProvidersCopier.copyFromBuilder(certificateProviders);
        }

        @Override
        public final Builder certificateProviders(Collection<CertificateProviderSummary> certificateProviders) {
            this.certificateProviders = CertificateProvidersCopier.copy(certificateProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateProviders(CertificateProviderSummary ... certificateProviders) {
            this.certificateProviders(Arrays.asList(certificateProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateProviders(Consumer<CertificateProviderSummary.Builder> ... certificateProviders) {
            this.certificateProviders(Stream.of(certificateProviders).map(c -> (CertificateProviderSummary)((CertificateProviderSummary.Builder)CertificateProviderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCertificateProvidersResponse build() {
            return new ListCertificateProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificateProvidersResponse> {
        public Builder certificateProviders(Collection<CertificateProviderSummary> var1);

        public Builder certificateProviders(CertificateProviderSummary ... var1);

        public Builder certificateProviders(Consumer<CertificateProviderSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

