/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandExecutionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandExecutionResult> {
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S").getter(CommandExecutionResult.getter(CommandExecutionResult::s)).setter(CommandExecutionResult.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<Boolean> B_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("B").getter(CommandExecutionResult.getter(CommandExecutionResult::b)).setter(CommandExecutionResult.setter(Builder::b)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()}).build();
    private static final SdkField<SdkBytes> BIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("BIN").getter(CommandExecutionResult.getter(CommandExecutionResult::bin)).setter(CommandExecutionResult.setter(Builder::bin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BIN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, B_FIELD, BIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S", S_FIELD);
            this.put("B", B_FIELD);
            this.put("BIN", BIN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s;
    private final Boolean b;
    private final SdkBytes bin;

    private CommandExecutionResult(BuilderImpl builder) {
        this.s = builder.s;
        this.b = builder.b;
        this.bin = builder.bin;
    }

    public final String s() {
        return this.s;
    }

    public final Boolean b() {
        return this.b;
    }

    public final SdkBytes bin() {
        return this.bin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.b());
        hashCode = 31 * hashCode + Objects.hashCode(this.bin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecutionResult)) {
            return false;
        }
        CommandExecutionResult other = (CommandExecutionResult)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.b(), other.b()) && Objects.equals(this.bin(), other.bin());
    }

    public final String toString() {
        return ToString.builder((String)"CommandExecutionResult").add("S", (Object)this.s()).add("B", (Object)this.b()).add("BIN", (Object)this.bin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "B": {
                return Optional.ofNullable(clazz.cast(this.b()));
            }
            case "BIN": {
                return Optional.ofNullable(clazz.cast(this.bin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CommandExecutionResult, T> g) {
        return obj -> g.apply((CommandExecutionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private Boolean b;
        private SdkBytes bin;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecutionResult model) {
            this.s(model.s);
            this.b(model.b);
            this.bin(model.bin);
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final Boolean getB() {
            return this.b;
        }

        public final void setB(Boolean b) {
            this.b = b;
        }

        @Override
        public final Builder b(Boolean b) {
            this.b = b;
            return this;
        }

        public final ByteBuffer getBin() {
            return this.bin == null ? null : this.bin.asByteBuffer();
        }

        public final void setBin(ByteBuffer bin) {
            this.bin(bin == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bin));
        }

        @Override
        public final Builder bin(SdkBytes bin) {
            this.bin = bin;
            return this;
        }

        public CommandExecutionResult build() {
            return new CommandExecutionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandExecutionResult> {
        public Builder s(String var1);

        public Builder b(Boolean var1);

        public Builder bin(SdkBytes var1);
    }
}

