/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommandResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateCommandResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandId").getter(CreateCommandResponse.getter(CreateCommandResponse::commandId)).setter(CreateCommandResponse.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandId").build()}).build();
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(CreateCommandResponse.getter(CreateCommandResponse::commandArn)).setter(CreateCommandResponse.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, COMMAND_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("commandId", COMMAND_ID_FIELD);
            this.put("commandArn", COMMAND_ARN_FIELD);
        }
    });
    private final String commandId;
    private final String commandArn;

    private CreateCommandResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.commandArn = builder.commandArn;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommandResponse)) {
            return false;
        }
        CreateCommandResponse other = (CreateCommandResponse)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.commandArn(), other.commandArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCommandResponse").add("CommandId", (Object)this.commandId()).add("CommandArn", (Object)this.commandArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommandResponse, T> g) {
        return obj -> g.apply((CreateCommandResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String commandId;
        private String commandArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommandResponse model) {
            super(model);
            this.commandId(model.commandId);
            this.commandArn(model.commandArn);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        @Override
        public CreateCommandResponse build() {
            return new CreateCommandResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommandResponse> {
        public Builder commandId(String var1);

        public Builder commandArn(String var1);
    }
}

