/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.SbomValidationErrorCode;
import software.amazon.awssdk.services.iot.model.SbomValidationResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SbomValidationResultSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SbomValidationResultSummary> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileName").getter(SbomValidationResultSummary.getter(SbomValidationResultSummary::fileName)).setter(SbomValidationResultSummary.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> VALIDATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationResult").getter(SbomValidationResultSummary.getter(SbomValidationResultSummary::validationResultAsString)).setter(SbomValidationResultSummary.setter(Builder::validationResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationResult").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(SbomValidationResultSummary.getter(SbomValidationResultSummary::errorCodeAsString)).setter(SbomValidationResultSummary.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(SbomValidationResultSummary.getter(SbomValidationResultSummary::errorMessage)).setter(SbomValidationResultSummary.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, VALIDATION_RESULT_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final String validationResult;
    private final String errorCode;
    private final String errorMessage;

    private SbomValidationResultSummary(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.validationResult = builder.validationResult;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final SbomValidationResult validationResult() {
        return SbomValidationResult.fromValue(this.validationResult);
    }

    public final String validationResultAsString() {
        return this.validationResult;
    }

    public final SbomValidationErrorCode errorCode() {
        return SbomValidationErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SbomValidationResultSummary)) {
            return false;
        }
        SbomValidationResultSummary other = (SbomValidationResultSummary)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.validationResultAsString(), other.validationResultAsString()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"SbomValidationResultSummary").add("FileName", (Object)this.fileName()).add("ValidationResult", (Object)this.validationResultAsString()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "validationResult": {
                return Optional.ofNullable(clazz.cast(this.validationResultAsString()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SbomValidationResultSummary, T> g) {
        return obj -> g.apply((SbomValidationResultSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private String validationResult;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SbomValidationResultSummary model) {
            this.fileName(model.fileName);
            this.validationResult(model.validationResult);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getValidationResult() {
            return this.validationResult;
        }

        public final void setValidationResult(String validationResult) {
            this.validationResult = validationResult;
        }

        @Override
        public final Builder validationResult(String validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        @Override
        public final Builder validationResult(SbomValidationResult validationResult) {
            this.validationResult(validationResult == null ? null : validationResult.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(SbomValidationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public SbomValidationResultSummary build() {
            return new SbomValidationResultSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SbomValidationResultSummary> {
        public Builder fileName(String var1);

        public Builder validationResult(String var1);

        public Builder validationResult(SbomValidationResult var1);

        public Builder errorCode(String var1);

        public Builder errorCode(SbomValidationErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

