/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ViolationEventType {
    IN_ALARM("in-alarm"),
    ALARM_CLEARED("alarm-cleared"),
    ALARM_INVALIDATED("alarm-invalidated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ViolationEventType> VALUE_MAP;
    private final String value;

    private ViolationEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViolationEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViolationEventType> knownValues() {
        EnumSet<ViolationEventType> knownValues = EnumSet.allOf(ViolationEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ViolationEventType.class, ViolationEventType::toString);
    }
}

