/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ActiveViolation;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;

public class ListActiveViolationsIterable
implements SdkIterable<ListActiveViolationsResponse> {
    private final IotClient client;
    private final ListActiveViolationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActiveViolationsIterable(IotClient client, ListActiveViolationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActiveViolationsResponseFetcher();
    }

    public Iterator<ListActiveViolationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActiveViolation> activeViolations() {
        Function<ListActiveViolationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activeViolations() != null) {
                return response.activeViolations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActiveViolationsResponseFetcher
    implements SyncPageFetcher<ListActiveViolationsResponse> {
        private ListActiveViolationsResponseFetcher() {
        }

        public boolean hasNextPage(ListActiveViolationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActiveViolationsResponse nextPage(ListActiveViolationsResponse previousPage) {
            if (previousPage == null) {
                return ListActiveViolationsIterable.this.client.listActiveViolations(ListActiveViolationsIterable.this.firstRequest);
            }
            return ListActiveViolationsIterable.this.client.listActiveViolations((ListActiveViolationsRequest)((Object)ListActiveViolationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

