/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PackageVersionSummary;
import software.amazon.awssdk.services.iot.model.PackageVersionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackageVersionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListPackageVersionsResponse> {
    private static final SdkField<List<PackageVersionSummary>> PACKAGE_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packageVersionSummaries").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::packageVersionSummaries)).setter(ListPackageVersionsResponse.setter(Builder::packageVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::nextToken)).setter(ListPackageVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PackageVersionSummary> packageVersionSummaries;
    private final String nextToken;

    private ListPackageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersionSummaries = builder.packageVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPackageVersionSummaries() {
        return this.packageVersionSummaries != null && !(this.packageVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<PackageVersionSummary> packageVersionSummaries() {
        return this.packageVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageVersionSummaries() ? this.packageVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionsResponse)) {
            return false;
        }
        ListPackageVersionsResponse other = (ListPackageVersionsResponse)((Object)obj);
        return this.hasPackageVersionSummaries() == other.hasPackageVersionSummaries() && Objects.equals(this.packageVersionSummaries(), other.packageVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackageVersionsResponse").add("PackageVersionSummaries", this.hasPackageVersionSummaries() ? this.packageVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.packageVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionsResponse, T> g) {
        return obj -> g.apply((ListPackageVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<PackageVersionSummary> packageVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionsResponse model) {
            super(model);
            this.packageVersionSummaries(model.packageVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PackageVersionSummary.Builder> getPackageVersionSummaries() {
            List<PackageVersionSummary.Builder> result = PackageVersionSummaryListCopier.copyToBuilder(this.packageVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageVersionSummaries(Collection<PackageVersionSummary.BuilderImpl> packageVersionSummaries) {
            this.packageVersionSummaries = PackageVersionSummaryListCopier.copyFromBuilder(packageVersionSummaries);
        }

        @Override
        public final Builder packageVersionSummaries(Collection<PackageVersionSummary> packageVersionSummaries) {
            this.packageVersionSummaries = PackageVersionSummaryListCopier.copy(packageVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageVersionSummaries(PackageVersionSummary ... packageVersionSummaries) {
            this.packageVersionSummaries(Arrays.asList(packageVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageVersionSummaries(Consumer<PackageVersionSummary.Builder> ... packageVersionSummaries) {
            this.packageVersionSummaries(Stream.of(packageVersionSummaries).map(c -> (PackageVersionSummary)((PackageVersionSummary.Builder)PackageVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPackageVersionsResponse build() {
            return new ListPackageVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackageVersionsResponse> {
        public Builder packageVersionSummaries(Collection<PackageVersionSummary> var1);

        public Builder packageVersionSummaries(PackageVersionSummary ... var1);

        public Builder packageVersionSummaries(Consumer<PackageVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

