/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(OpenSearchAction.getter(OpenSearchAction::roleArn)).setter(OpenSearchAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(OpenSearchAction.getter(OpenSearchAction::endpoint)).setter(OpenSearchAction.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("index").getter(OpenSearchAction.getter(OpenSearchAction::index)).setter(OpenSearchAction.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(OpenSearchAction.getter(OpenSearchAction::type)).setter(OpenSearchAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(OpenSearchAction.getter(OpenSearchAction::id)).setter(OpenSearchAction.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, ENDPOINT_FIELD, INDEX_FIELD, TYPE_FIELD, ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String endpoint;
    private final String index;
    private final String type;
    private final String id;

    private OpenSearchAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String index() {
        return this.index;
    }

    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchAction)) {
            return false;
        }
        OpenSearchAction other = (OpenSearchAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.index(), other.index()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchAction").add("RoleArn", (Object)this.roleArn()).add("Endpoint", (Object)this.endpoint()).add("Index", (Object)this.index()).add("Type", (Object)this.type()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchAction, T> g) {
        return obj -> g.apply((OpenSearchAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String endpoint;
        private String index;
        private String type;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchAction model) {
            this.roleArn(model.roleArn);
            this.endpoint(model.endpoint);
            this.index(model.index);
            this.type(model.type);
            this.id(model.id);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getIndex() {
            return this.index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public OpenSearchAction build() {
            return new OpenSearchAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchAction> {
        public Builder roleArn(String var1);

        public Builder endpoint(String var1);

        public Builder index(String var1);

        public Builder type(String var1);

        public Builder id(String var1);
    }
}

