/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to publish data to an Amazon SQS queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqsAction implements SdkPojo, Serializable, ToCopyableBuilder<SqsAction.Builder, SqsAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(SqsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueUrl").getter(getter(SqsAction::queueUrl)).setter(setter(Builder::queueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueUrl").build()).build();

    private static final SdkField<Boolean> USE_BASE64_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useBase64").getter(getter(SqsAction::useBase64)).setter(setter(Builder::useBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useBase64").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            QUEUE_URL_FIELD, USE_BASE64_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String queueUrl;

    private final Boolean useBase64;

    private SqsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.queueUrl = builder.queueUrl;
        this.useBase64 = builder.useBase64;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue.
     */
    public final String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * Specifies whether to use Base64 encoding.
     * </p>
     * 
     * @return Specifies whether to use Base64 encoding.
     */
    public final Boolean useBase64() {
        return useBase64;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(useBase64());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsAction)) {
            return false;
        }
        SqsAction other = (SqsAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(queueUrl(), other.queueUrl())
                && Objects.equals(useBase64(), other.useBase64());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqsAction").add("RoleArn", roleArn()).add("QueueUrl", queueUrl()).add("UseBase64", useBase64())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "queueUrl":
            return Optional.ofNullable(clazz.cast(queueUrl()));
        case "useBase64":
            return Optional.ofNullable(clazz.cast(useBase64()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqsAction, T> g) {
        return obj -> g.apply((SqsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqsAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The URL of the Amazon SQS queue.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * Specifies whether to use Base64 encoding.
         * </p>
         * 
         * @param useBase64
         *        Specifies whether to use Base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBase64(Boolean useBase64);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String queueUrl;

        private Boolean useBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsAction model) {
            roleArn(model.roleArn);
            queueUrl(model.queueUrl);
            useBase64(model.useBase64);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final Boolean getUseBase64() {
            return useBase64;
        }

        public final void setUseBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
        }

        @Override
        public final Builder useBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
            return this;
        }

        @Override
        public SqsAction build() {
            return new SqsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
