/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;

public class ListThingGroupsPublisher
implements SdkPublisher<ListThingGroupsResponse> {
    private final IotAsyncClient client;
    private final ListThingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingGroupsPublisher(IotAsyncClient client, ListThingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingGroupsPublisher(IotAsyncClient client, ListThingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupNameAndArn> thingGroups() {
        Function<ListThingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingGroups() != null) {
                return response.thingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingGroupsResponseFetcher
    implements AsyncPageFetcher<ListThingGroupsResponse> {
        private ListThingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingGroupsResponse> nextPage(ListThingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListThingGroupsPublisher.this.client.listThingGroups(ListThingGroupsPublisher.this.firstRequest);
            }
            return ListThingGroupsPublisher.this.client.listThingGroups((ListThingGroupsRequest)((Object)ListThingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

