/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.ThingGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddThingsToThingGroupParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddThingsToThingGroupParams> {
    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroupNames").getter(AddThingsToThingGroupParams.getter(AddThingsToThingGroupParams::thingGroupNames)).setter(AddThingsToThingGroupParams.setter(Builder::thingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overrideDynamicGroups").getter(AddThingsToThingGroupParams.getter(AddThingsToThingGroupParams::overrideDynamicGroups)).setter(AddThingsToThingGroupParams.setter(Builder::overrideDynamicGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAMES_FIELD, OVERRIDE_DYNAMIC_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> thingGroupNames;
    private final Boolean overrideDynamicGroups;

    private AddThingsToThingGroupParams(BuilderImpl builder) {
        this.thingGroupNames = builder.thingGroupNames;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    public final boolean hasThingGroupNames() {
        return this.thingGroupNames != null && !(this.thingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> thingGroupNames() {
        return this.thingGroupNames;
    }

    public final Boolean overrideDynamicGroups() {
        return this.overrideDynamicGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroupNames() ? this.thingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideDynamicGroups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddThingsToThingGroupParams)) {
            return false;
        }
        AddThingsToThingGroupParams other = (AddThingsToThingGroupParams)obj;
        return this.hasThingGroupNames() == other.hasThingGroupNames() && Objects.equals(this.thingGroupNames(), other.thingGroupNames()) && Objects.equals(this.overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    public final String toString() {
        return ToString.builder((String)"AddThingsToThingGroupParams").add("ThingGroupNames", this.hasThingGroupNames() ? this.thingGroupNames() : null).add("OverrideDynamicGroups", (Object)this.overrideDynamicGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.thingGroupNames()));
            }
            case "overrideDynamicGroups": {
                return Optional.ofNullable(clazz.cast(this.overrideDynamicGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddThingsToThingGroupParams, T> g) {
        return obj -> g.apply((AddThingsToThingGroupParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(AddThingsToThingGroupParams model) {
            this.thingGroupNames(model.thingGroupNames);
            this.overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final Collection<String> getThingGroupNames() {
            if (this.thingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.thingGroupNames;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
        }

        @Override
        @Transient
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder thingGroupNames(String ... thingGroupNames) {
            this.thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final Boolean getOverrideDynamicGroups() {
            return this.overrideDynamicGroups;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        @Transient
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        public AddThingsToThingGroupParams build() {
            return new AddThingsToThingGroupParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddThingsToThingGroupParams> {
        public Builder thingGroupNames(Collection<String> var1);

        public Builder thingGroupNames(String ... var1);

        public Builder overrideDynamicGroups(Boolean var1);
    }
}

