/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComparisonOperator {
    LESS_THAN("less-than"),
    LESS_THAN_EQUALS("less-than-equals"),
    GREATER_THAN("greater-than"),
    GREATER_THAN_EQUALS("greater-than-equals"),
    IN_CIDR_SET("in-cidr-set"),
    NOT_IN_CIDR_SET("not-in-cidr-set"),
    IN_PORT_SET("in-port-set"),
    NOT_IN_PORT_SET("not-in-port-set"),
    IN_SET("in-set"),
    NOT_IN_SET("not-in-set"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ComparisonOperator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonOperator> knownValues() {
        return Stream.of(ComparisonOperator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

