/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration;
import software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIndexingConfigurationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetIndexingConfigurationResponse> {
    private static final SdkField<ThingIndexingConfiguration> THING_INDEXING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("thingIndexingConfiguration").getter(GetIndexingConfigurationResponse.getter(GetIndexingConfigurationResponse::thingIndexingConfiguration)).setter(GetIndexingConfigurationResponse.setter(Builder::thingIndexingConfiguration)).constructor(ThingIndexingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingConfiguration").build()}).build();
    private static final SdkField<ThingGroupIndexingConfiguration> THING_GROUP_INDEXING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("thingGroupIndexingConfiguration").getter(GetIndexingConfigurationResponse.getter(GetIndexingConfigurationResponse::thingGroupIndexingConfiguration)).setter(GetIndexingConfigurationResponse.setter(Builder::thingGroupIndexingConfiguration)).constructor(ThingGroupIndexingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupIndexingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_CONFIGURATION_FIELD, THING_GROUP_INDEXING_CONFIGURATION_FIELD));
    private final ThingIndexingConfiguration thingIndexingConfiguration;
    private final ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

    private GetIndexingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.thingIndexingConfiguration = builder.thingIndexingConfiguration;
        this.thingGroupIndexingConfiguration = builder.thingGroupIndexingConfiguration;
    }

    public final ThingIndexingConfiguration thingIndexingConfiguration() {
        return this.thingIndexingConfiguration;
    }

    public final ThingGroupIndexingConfiguration thingGroupIndexingConfiguration() {
        return this.thingGroupIndexingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingIndexingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupIndexingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexingConfigurationResponse)) {
            return false;
        }
        GetIndexingConfigurationResponse other = (GetIndexingConfigurationResponse)((Object)obj);
        return Objects.equals(this.thingIndexingConfiguration(), other.thingIndexingConfiguration()) && Objects.equals(this.thingGroupIndexingConfiguration(), other.thingGroupIndexingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetIndexingConfigurationResponse").add("ThingIndexingConfiguration", (Object)this.thingIndexingConfiguration()).add("ThingGroupIndexingConfiguration", (Object)this.thingGroupIndexingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingIndexingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thingIndexingConfiguration()));
            }
            case "thingGroupIndexingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thingGroupIndexingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexingConfigurationResponse, T> g) {
        return obj -> g.apply((GetIndexingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private ThingIndexingConfiguration thingIndexingConfiguration;
        private ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexingConfigurationResponse model) {
            super(model);
            this.thingIndexingConfiguration(model.thingIndexingConfiguration);
            this.thingGroupIndexingConfiguration(model.thingGroupIndexingConfiguration);
        }

        public final ThingIndexingConfiguration.Builder getThingIndexingConfiguration() {
            return this.thingIndexingConfiguration != null ? this.thingIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration;
            return this;
        }

        public final void setThingIndexingConfiguration(ThingIndexingConfiguration.BuilderImpl thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration != null ? thingIndexingConfiguration.build() : null;
        }

        public final ThingGroupIndexingConfiguration.Builder getThingGroupIndexingConfiguration() {
            return this.thingGroupIndexingConfiguration != null ? this.thingGroupIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration;
            return this;
        }

        public final void setThingGroupIndexingConfiguration(ThingGroupIndexingConfiguration.BuilderImpl thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration.build() : null;
        }

        @Override
        public GetIndexingConfigurationResponse build() {
            return new GetIndexingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIndexingConfigurationResponse> {
        public Builder thingIndexingConfiguration(ThingIndexingConfiguration var1);

        default public Builder thingIndexingConfiguration(Consumer<ThingIndexingConfiguration.Builder> thingIndexingConfiguration) {
            return this.thingIndexingConfiguration((ThingIndexingConfiguration)((ThingIndexingConfiguration.Builder)ThingIndexingConfiguration.builder().applyMutation(thingIndexingConfiguration)).build());
        }

        public Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration var1);

        default public Builder thingGroupIndexingConfiguration(Consumer<ThingGroupIndexingConfiguration.Builder> thingGroupIndexingConfiguration) {
            return this.thingGroupIndexingConfiguration((ThingGroupIndexingConfiguration)((ThingGroupIndexingConfiguration.Builder)ThingGroupIndexingConfiguration.builder().applyMutation(thingGroupIndexingConfiguration)).build());
        }
    }
}

