/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing indexing configuration. For more information, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing Thing Indexing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingIndexingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingIndexingConfiguration.Builder, ThingIndexingConfiguration> {
    private static final SdkField<String> THING_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingIndexingMode").getter(getter(ThingIndexingConfiguration::thingIndexingModeAsString))
            .setter(setter(Builder::thingIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingMode").build()).build();

    private static final SdkField<String> THING_CONNECTIVITY_INDEXING_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("thingConnectivityIndexingMode")
            .getter(getter(ThingIndexingConfiguration::thingConnectivityIndexingModeAsString))
            .setter(setter(Builder::thingConnectivityIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingConnectivityIndexingMode")
                    .build()).build();

    private static final SdkField<List<Field>> MANAGED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("managedFields")
            .getter(getter(ThingIndexingConfiguration::managedFields))
            .setter(setter(Builder::managedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Field>> CUSTOM_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("customFields")
            .getter(getter(ThingIndexingConfiguration::customFields))
            .setter(setter(Builder::customFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_MODE_FIELD,
            THING_CONNECTIVITY_INDEXING_MODE_FIELD, MANAGED_FIELDS_FIELD, CUSTOM_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingIndexingMode;

    private final String thingConnectivityIndexingMode;

    private final List<Field> managedFields;

    private final List<Field> customFields;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
        this.thingConnectivityIndexingMode = builder.thingConnectivityIndexingMode;
        this.managedFields = builder.managedFields;
        this.customFields = builder.customFields;
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public final ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(thingIndexingMode);
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public final String thingIndexingModeAsString() {
        return thingIndexingMode;
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
     * must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         thingIndexMode must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public final ThingConnectivityIndexingMode thingConnectivityIndexingMode() {
        return ThingConnectivityIndexingMode.fromValue(thingConnectivityIndexingMode);
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
     * must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         thingIndexMode must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public final String thingConnectivityIndexingModeAsString() {
        return thingConnectivityIndexingMode;
    }

    /**
     * Returns true if the ManagedFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasManagedFields() {
        return managedFields != null && !(managedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasManagedFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
     */
    public final List<Field> managedFields() {
        return managedFields;
    }

    /**
     * Returns true if the CustomFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCustomFields() {
        return customFields != null && !(customFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains custom field names and their data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains custom field names and their data type.
     */
    public final List<Field> customFields() {
        return customFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thingConnectivityIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedFields() ? managedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomFields() ? customFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration) obj;
        return Objects.equals(thingIndexingModeAsString(), other.thingIndexingModeAsString())
                && Objects.equals(thingConnectivityIndexingModeAsString(), other.thingConnectivityIndexingModeAsString())
                && hasManagedFields() == other.hasManagedFields() && Objects.equals(managedFields(), other.managedFields())
                && hasCustomFields() == other.hasCustomFields() && Objects.equals(customFields(), other.customFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingIndexingConfiguration").add("ThingIndexingMode", thingIndexingModeAsString())
                .add("ThingConnectivityIndexingMode", thingConnectivityIndexingModeAsString())
                .add("ManagedFields", hasManagedFields() ? managedFields() : null)
                .add("CustomFields", hasCustomFields() ? customFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingMode":
            return Optional.ofNullable(clazz.cast(thingIndexingModeAsString()));
        case "thingConnectivityIndexingMode":
            return Optional.ofNullable(clazz.cast(thingConnectivityIndexingModeAsString()));
        case "managedFields":
            return Optional.ofNullable(clazz.cast(managedFields()));
        case "customFields":
            return Optional.ofNullable(clazz.cast(customFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingIndexingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingIndexingConfiguration> {
        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(String thingIndexingMode);

        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(ThingIndexingMode thingIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
         * must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        thingIndexMode must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
         * must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        thingIndexMode must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Collection<Field> managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Field... managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #managedFields(List<Field>)}.
         * 
         * @param managedFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedFields(List<Field>)
         */
        Builder managedFields(Consumer<Field.Builder>... managedFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Collection<Field> customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Field... customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #customFields(List<Field>)}.
         * 
         * @param customFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFields(List<Field>)
         */
        Builder customFields(Consumer<Field.Builder>... customFields);
    }

    static final class BuilderImpl implements Builder {
        private String thingIndexingMode;

        private String thingConnectivityIndexingMode;

        private List<Field> managedFields = DefaultSdkAutoConstructList.getInstance();

        private List<Field> customFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            thingIndexingMode(model.thingIndexingMode);
            thingConnectivityIndexingMode(model.thingConnectivityIndexingMode);
            managedFields(model.managedFields);
            customFields(model.customFields);
        }

        public final String getThingIndexingMode() {
            return thingIndexingMode;
        }

        @Override
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode == null ? null : thingIndexingMode.toString());
            return this;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        public final String getThingConnectivityIndexingMode() {
            return thingConnectivityIndexingMode;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
            return this;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode(thingConnectivityIndexingMode == null ? null : thingConnectivityIndexingMode
                    .toString());
            return this;
        }

        public final void setThingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
        }

        public final Collection<Field.Builder> getManagedFields() {
            if (managedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return managedFields != null ? managedFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedFields(Collection<Field> managedFields) {
            this.managedFields = FieldsCopier.copy(managedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Field... managedFields) {
            managedFields(Arrays.asList(managedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Consumer<Field.Builder>... managedFields) {
            managedFields(Stream.of(managedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setManagedFields(Collection<Field.BuilderImpl> managedFields) {
            this.managedFields = FieldsCopier.copyFromBuilder(managedFields);
        }

        public final Collection<Field.Builder> getCustomFields() {
            if (customFields instanceof SdkAutoConstructList) {
                return null;
            }
            return customFields != null ? customFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customFields(Collection<Field> customFields) {
            this.customFields = FieldsCopier.copy(customFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Field... customFields) {
            customFields(Arrays.asList(customFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Consumer<Field.Builder>... customFields) {
            customFields(Stream.of(customFields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomFields(Collection<Field.BuilderImpl> customFields) {
            this.customFields = FieldsCopier.copyFromBuilder(customFields);
        }

        @Override
        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
