/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAuthorizationRequest extends IotRequest implements
        ToCopyableBuilder<TestAuthorizationRequest.Builder, TestAuthorizationRequest> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(TestAuthorizationRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cognitoIdentityPoolId").getter(getter(TestAuthorizationRequest::cognitoIdentityPoolId))
            .setter(setter(Builder::cognitoIdentityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build())
            .build();

    private static final SdkField<List<AuthInfo>> AUTH_INFOS_FIELD = SdkField
            .<List<AuthInfo>> builder(MarshallingType.LIST)
            .memberName("authInfos")
            .getter(getter(TestAuthorizationRequest::authInfos))
            .setter(setter(Builder::authInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(TestAuthorizationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientId").build()).build();

    private static final SdkField<List<String>> POLICY_NAMES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("policyNamesToAdd")
            .getter(getter(TestAuthorizationRequest::policyNamesToAdd))
            .setter(setter(Builder::policyNamesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyNamesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> POLICY_NAMES_TO_SKIP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("policyNamesToSkip")
            .getter(getter(TestAuthorizationRequest::policyNamesToSkip))
            .setter(setter(Builder::policyNamesToSkip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyNamesToSkip").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            COGNITO_IDENTITY_POOL_ID_FIELD, AUTH_INFOS_FIELD, CLIENT_ID_FIELD, POLICY_NAMES_TO_ADD_FIELD,
            POLICY_NAMES_TO_SKIP_FIELD));

    private final String principal;

    private final String cognitoIdentityPoolId;

    private final List<AuthInfo> authInfos;

    private final String clientId;

    private final List<String> policyNamesToAdd;

    private final List<String> policyNamesToSkip;

    private TestAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.authInfos = builder.authInfos;
        this.clientId = builder.clientId;
        this.policyNamesToAdd = builder.policyNamesToAdd;
        this.policyNamesToSkip = builder.policyNamesToSkip;
    }

    /**
     * <p>
     * The principal. Valid principals are CertificateArn
     * (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn
     * (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).
     * </p>
     * 
     * @return The principal. Valid principals are CertificateArn
     *         (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn
     *         (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId
     *         (<i>region</i>:<i>id</i>).
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * The Cognito identity pool ID.
     * </p>
     * 
     * @return The Cognito identity pool ID.
     */
    public final String cognitoIdentityPoolId() {
        return cognitoIdentityPoolId;
    }

    /**
     * Returns true if the AuthInfos property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAuthInfos() {
        return authInfos != null && !(authInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of authorization info objects. Simulating authorization will create a response for each
     * <code>authInfo</code> object in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of authorization info objects. Simulating authorization will create a response for each
     *         <code>authInfo</code> object in the list.
     */
    public final List<AuthInfo> authInfos() {
        return authInfos;
    }

    /**
     * <p>
     * The MQTT client ID.
     * </p>
     * 
     * @return The MQTT client ID.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * Returns true if the PolicyNamesToAdd property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPolicyNamesToAdd() {
        return policyNamesToAdd != null && !(policyNamesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When testing custom authorization, the policies specified here are treated as if they are attached to the
     * principal being authorized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyNamesToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When testing custom authorization, the policies specified here are treated as if they are attached to the
     *         principal being authorized.
     */
    public final List<String> policyNamesToAdd() {
        return policyNamesToAdd;
    }

    /**
     * Returns true if the PolicyNamesToSkip property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPolicyNamesToSkip() {
        return policyNamesToSkip != null && !(policyNamesToSkip instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When testing custom authorization, the policies specified here are treated as if they are not attached to the
     * principal being authorized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyNamesToSkip()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When testing custom authorization, the policies specified here are treated as if they are not attached to
     *         the principal being authorized.
     */
    public final List<String> policyNamesToSkip() {
        return policyNamesToSkip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthInfos() ? authInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyNamesToAdd() ? policyNamesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyNamesToSkip() ? policyNamesToSkip() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationRequest)) {
            return false;
        }
        TestAuthorizationRequest other = (TestAuthorizationRequest) obj;
        return Objects.equals(principal(), other.principal())
                && Objects.equals(cognitoIdentityPoolId(), other.cognitoIdentityPoolId())
                && hasAuthInfos() == other.hasAuthInfos() && Objects.equals(authInfos(), other.authInfos())
                && Objects.equals(clientId(), other.clientId()) && hasPolicyNamesToAdd() == other.hasPolicyNamesToAdd()
                && Objects.equals(policyNamesToAdd(), other.policyNamesToAdd())
                && hasPolicyNamesToSkip() == other.hasPolicyNamesToSkip()
                && Objects.equals(policyNamesToSkip(), other.policyNamesToSkip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestAuthorizationRequest").add("Principal", principal())
                .add("CognitoIdentityPoolId", cognitoIdentityPoolId()).add("AuthInfos", hasAuthInfos() ? authInfos() : null)
                .add("ClientId", clientId()).add("PolicyNamesToAdd", hasPolicyNamesToAdd() ? policyNamesToAdd() : null)
                .add("PolicyNamesToSkip", hasPolicyNamesToSkip() ? policyNamesToSkip() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "cognitoIdentityPoolId":
            return Optional.ofNullable(clazz.cast(cognitoIdentityPoolId()));
        case "authInfos":
            return Optional.ofNullable(clazz.cast(authInfos()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "policyNamesToAdd":
            return Optional.ofNullable(clazz.cast(policyNamesToAdd()));
        case "policyNamesToSkip":
            return Optional.ofNullable(clazz.cast(policyNamesToSkip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAuthorizationRequest, T> g) {
        return obj -> g.apply((TestAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestAuthorizationRequest> {
        /**
         * <p>
         * The principal. Valid principals are CertificateArn
         * (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn
         * (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId
         * (<i>region</i>:<i>id</i>).
         * </p>
         * 
         * @param principal
         *        The principal. Valid principals are CertificateArn
         *        (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn
         *        (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId
         *        (<i>region</i>:<i>id</i>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The Cognito identity pool ID.
         * </p>
         * 
         * @param cognitoIdentityPoolId
         *        The Cognito identity pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityPoolId(String cognitoIdentityPoolId);

        /**
         * <p>
         * A list of authorization info objects. Simulating authorization will create a response for each
         * <code>authInfo</code> object in the list.
         * </p>
         * 
         * @param authInfos
         *        A list of authorization info objects. Simulating authorization will create a response for each
         *        <code>authInfo</code> object in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authInfos(Collection<AuthInfo> authInfos);

        /**
         * <p>
         * A list of authorization info objects. Simulating authorization will create a response for each
         * <code>authInfo</code> object in the list.
         * </p>
         * 
         * @param authInfos
         *        A list of authorization info objects. Simulating authorization will create a response for each
         *        <code>authInfo</code> object in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authInfos(AuthInfo... authInfos);

        /**
         * <p>
         * A list of authorization info objects. Simulating authorization will create a response for each
         * <code>authInfo</code> object in the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthInfo>.Builder} avoiding the need to
         * create one manually via {@link List<AuthInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #authInfos(List<AuthInfo>)}.
         * 
         * @param authInfos
         *        a consumer that will call methods on {@link List<AuthInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authInfos(List<AuthInfo>)
         */
        Builder authInfos(Consumer<AuthInfo.Builder>... authInfos);

        /**
         * <p>
         * The MQTT client ID.
         * </p>
         * 
         * @param clientId
         *        The MQTT client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * When testing custom authorization, the policies specified here are treated as if they are attached to the
         * principal being authorized.
         * </p>
         * 
         * @param policyNamesToAdd
         *        When testing custom authorization, the policies specified here are treated as if they are attached to
         *        the principal being authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNamesToAdd(Collection<String> policyNamesToAdd);

        /**
         * <p>
         * When testing custom authorization, the policies specified here are treated as if they are attached to the
         * principal being authorized.
         * </p>
         * 
         * @param policyNamesToAdd
         *        When testing custom authorization, the policies specified here are treated as if they are attached to
         *        the principal being authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNamesToAdd(String... policyNamesToAdd);

        /**
         * <p>
         * When testing custom authorization, the policies specified here are treated as if they are not attached to the
         * principal being authorized.
         * </p>
         * 
         * @param policyNamesToSkip
         *        When testing custom authorization, the policies specified here are treated as if they are not attached
         *        to the principal being authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNamesToSkip(Collection<String> policyNamesToSkip);

        /**
         * <p>
         * When testing custom authorization, the policies specified here are treated as if they are not attached to the
         * principal being authorized.
         * </p>
         * 
         * @param policyNamesToSkip
         *        When testing custom authorization, the policies specified here are treated as if they are not attached
         *        to the principal being authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNamesToSkip(String... policyNamesToSkip);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String principal;

        private String cognitoIdentityPoolId;

        private List<AuthInfo> authInfos = DefaultSdkAutoConstructList.getInstance();

        private String clientId;

        private List<String> policyNamesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> policyNamesToSkip = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestAuthorizationRequest model) {
            super(model);
            principal(model.principal);
            cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            authInfos(model.authInfos);
            clientId(model.clientId);
            policyNamesToAdd(model.policyNamesToAdd);
            policyNamesToSkip(model.policyNamesToSkip);
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getCognitoIdentityPoolId() {
            return cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final Collection<AuthInfo.Builder> getAuthInfos() {
            if (authInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return authInfos != null ? authInfos.stream().map(AuthInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authInfos(Collection<AuthInfo> authInfos) {
            this.authInfos = AuthInfosCopier.copy(authInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authInfos(AuthInfo... authInfos) {
            authInfos(Arrays.asList(authInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authInfos(Consumer<AuthInfo.Builder>... authInfos) {
            authInfos(Stream.of(authInfos).map(c -> AuthInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthInfos(Collection<AuthInfo.BuilderImpl> authInfos) {
            this.authInfos = AuthInfosCopier.copyFromBuilder(authInfos);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Collection<String> getPolicyNamesToAdd() {
            if (policyNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return policyNamesToAdd;
        }

        @Override
        public final Builder policyNamesToAdd(Collection<String> policyNamesToAdd) {
            this.policyNamesToAdd = PolicyNamesCopier.copy(policyNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNamesToAdd(String... policyNamesToAdd) {
            policyNamesToAdd(Arrays.asList(policyNamesToAdd));
            return this;
        }

        public final void setPolicyNamesToAdd(Collection<String> policyNamesToAdd) {
            this.policyNamesToAdd = PolicyNamesCopier.copy(policyNamesToAdd);
        }

        public final Collection<String> getPolicyNamesToSkip() {
            if (policyNamesToSkip instanceof SdkAutoConstructList) {
                return null;
            }
            return policyNamesToSkip;
        }

        @Override
        public final Builder policyNamesToSkip(Collection<String> policyNamesToSkip) {
            this.policyNamesToSkip = PolicyNamesCopier.copy(policyNamesToSkip);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNamesToSkip(String... policyNamesToSkip) {
            policyNamesToSkip(Arrays.asList(policyNamesToSkip));
            return this;
        }

        public final void setPolicyNamesToSkip(Collection<String> policyNamesToSkip) {
            this.policyNamesToSkip = PolicyNamesCopier.copy(policyNamesToSkip);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestAuthorizationRequest build() {
            return new TestAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
