/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAuditMitigationActionsTaskRequest extends IotRequest implements
        ToCopyableBuilder<StartAuditMitigationActionsTaskRequest.Builder, StartAuditMitigationActionsTaskRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(StartAuditMitigationActionsTaskRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()).build();

    private static final SdkField<AuditMitigationActionsTaskTarget> TARGET_FIELD = SdkField
            .<AuditMitigationActionsTaskTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(StartAuditMitigationActionsTaskRequest::target)).setter(setter(Builder::target))
            .constructor(AuditMitigationActionsTaskTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("auditCheckToActionsMapping")
            .getter(getter(StartAuditMitigationActionsTaskRequest::auditCheckToActionsMapping))
            .setter(setter(Builder::auditCheckToActionsMapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToActionsMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartAuditMitigationActionsTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TARGET_FIELD,
            AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String taskId;

    private final AuditMitigationActionsTaskTarget target;

    private final Map<String, List<String>> auditCheckToActionsMapping;

    private final String clientRequestToken;

    private StartAuditMitigationActionsTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.target = builder.target;
        this.auditCheckToActionsMapping = builder.auditCheckToActionsMapping;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * A unique identifier for the task. You can use this identifier to check the status of the task or to cancel it.
     * </p>
     * 
     * @return A unique identifier for the task. You can use this identifier to check the status of the task or to
     *         cancel it.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of audit
     * check, to all findings from an audit, or to a specific set of findings.
     * </p>
     * 
     * @return Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of
     *         audit check, to all findings from an audit, or to a specific set of findings.
     */
    public final AuditMitigationActionsTaskTarget target() {
        return target;
    }

    /**
     * Returns true if the AuditCheckToActionsMapping property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAuditCheckToActionsMapping() {
        return auditCheckToActionsMapping != null && !(auditCheckToActionsMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your AWS
     * account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuditCheckToActionsMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your
     *         AWS account.
     */
    public final Map<String, List<String>> auditCheckToActionsMapping() {
        return auditCheckToActionsMapping;
    }

    /**
     * <p>
     * Each audit mitigation task must have a unique client request token. If you try to start a new task with the same
     * token as a task that already exists, an exception occurs. If you omit this value, a unique client request token
     * is generated automatically.
     * </p>
     * 
     * @return Each audit mitigation task must have a unique client request token. If you try to start a new task with
     *         the same token as a task that already exists, an exception occurs. If you omit this value, a unique
     *         client request token is generated automatically.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditCheckToActionsMapping() ? auditCheckToActionsMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAuditMitigationActionsTaskRequest)) {
            return false;
        }
        StartAuditMitigationActionsTaskRequest other = (StartAuditMitigationActionsTaskRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(target(), other.target())
                && hasAuditCheckToActionsMapping() == other.hasAuditCheckToActionsMapping()
                && Objects.equals(auditCheckToActionsMapping(), other.auditCheckToActionsMapping())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAuditMitigationActionsTaskRequest").add("TaskId", taskId()).add("Target", target())
                .add("AuditCheckToActionsMapping", hasAuditCheckToActionsMapping() ? auditCheckToActionsMapping() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "auditCheckToActionsMapping":
            return Optional.ofNullable(clazz.cast(auditCheckToActionsMapping()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAuditMitigationActionsTaskRequest, T> g) {
        return obj -> g.apply((StartAuditMitigationActionsTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAuditMitigationActionsTaskRequest> {
        /**
         * <p>
         * A unique identifier for the task. You can use this identifier to check the status of the task or to cancel
         * it.
         * </p>
         * 
         * @param taskId
         *        A unique identifier for the task. You can use this identifier to check the status of the task or to
         *        cancel it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of
         * audit check, to all findings from an audit, or to a specific set of findings.
         * </p>
         * 
         * @param target
         *        Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type
         *        of audit check, to all findings from an audit, or to a specific set of findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(AuditMitigationActionsTaskTarget target);

        /**
         * <p>
         * Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of
         * audit check, to all findings from an audit, or to a specific set of findings.
         * </p>
         * This is a convenience that creates an instance of the {@link AuditMitigationActionsTaskTarget.Builder}
         * avoiding the need to create one manually via {@link AuditMitigationActionsTaskTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuditMitigationActionsTaskTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(AuditMitigationActionsTaskTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link AuditMitigationActionsTaskTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(AuditMitigationActionsTaskTarget)
         */
        default Builder target(Consumer<AuditMitigationActionsTaskTarget.Builder> target) {
            return target(AuditMitigationActionsTaskTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your AWS
         * account.
         * </p>
         * 
         * @param auditCheckToActionsMapping
         *        For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping);

        /**
         * <p>
         * Each audit mitigation task must have a unique client request token. If you try to start a new task with the
         * same token as a task that already exists, an exception occurs. If you omit this value, a unique client
         * request token is generated automatically.
         * </p>
         * 
         * @param clientRequestToken
         *        Each audit mitigation task must have a unique client request token. If you try to start a new task
         *        with the same token as a task that already exists, an exception occurs. If you omit this value, a
         *        unique client request token is generated automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private AuditMitigationActionsTaskTarget target;

        private Map<String, List<String>> auditCheckToActionsMapping = DefaultSdkAutoConstructMap.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAuditMitigationActionsTaskRequest model) {
            super(model);
            taskId(model.taskId);
            target(model.target);
            auditCheckToActionsMapping(model.auditCheckToActionsMapping);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final AuditMitigationActionsTaskTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(AuditMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(AuditMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToActionsMapping() {
            if (auditCheckToActionsMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return auditCheckToActionsMapping;
        }

        @Override
        public final Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
            return this;
        }

        public final void setAuditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAuditMitigationActionsTaskRequest build() {
            return new StartAuditMitigationActionsTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
