/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write a message to a Salesforce IoT Cloud Input Stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceAction.Builder, SalesforceAction> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(SalesforceAction::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(SalesforceAction::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String token;

    private final String url;

    private SalesforceAction(BuilderImpl builder) {
        this.token = builder.token;
        this.url = builder.url;
    }

    /**
     * <p>
     * The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from the
     * Salesforce IoT Cloud platform after creation of the Input Stream.
     * </p>
     * 
     * @return The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available
     *         from the Salesforce IoT Cloud platform after creation of the Input Stream.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud
     * platform after creation of the Input Stream.
     * </p>
     * 
     * @return The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT
     *         Cloud platform after creation of the Input Stream.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceAction)) {
            return false;
        }
        SalesforceAction other = (SalesforceAction) obj;
        return Objects.equals(token(), other.token()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceAction").add("Token", token()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceAction, T> g) {
        return obj -> g.apply((SalesforceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceAction> {
        /**
         * <p>
         * The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from
         * the Salesforce IoT Cloud platform after creation of the Input Stream.
         * </p>
         * 
         * @param token
         *        The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available
         *        from the Salesforce IoT Cloud platform after creation of the Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud
         * platform after creation of the Input Stream.
         * </p>
         * 
         * @param url
         *        The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT
         *        Cloud platform after creation of the Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String token;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceAction model) {
            token(model.token);
            url(model.url);
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public SalesforceAction build() {
            return new SalesforceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
