/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write data to an Amazon Kinesis stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisAction implements SdkPojo, Serializable, ToCopyableBuilder<KinesisAction.Builder, KinesisAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(KinesisAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamName").getter(getter(KinesisAction::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partitionKey").getter(getter(KinesisAction::partitionKey)).setter(setter(Builder::partitionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            STREAM_NAME_FIELD, PARTITION_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String streamName;

    private final String partitionKey;

    private KinesisAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.streamName = builder.streamName;
        this.partitionKey = builder.partitionKey;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The partition key.
     * </p>
     * 
     * @return The partition key.
     */
    public final String partitionKey() {
        return partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(partitionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisAction)) {
            return false;
        }
        KinesisAction other = (KinesisAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(partitionKey(), other.partitionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisAction").add("RoleArn", roleArn()).add("StreamName", streamName())
                .add("PartitionKey", partitionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "streamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "partitionKey":
            return Optional.ofNullable(clazz.cast(partitionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisAction, T> g) {
        return obj -> g.apply((KinesisAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the Amazon Kinesis stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The partition key.
         * </p>
         * 
         * @param partitionKey
         *        The partition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(String partitionKey);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String streamName;

        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisAction model) {
            roleArn(model.roleArn);
            streamName(model.streamName);
            partitionKey(model.partitionKey);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getPartitionKey() {
            return partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public KinesisAction build() {
            return new KinesisAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
