/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job process details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobProcessDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<JobProcessDetails.Builder, JobProcessDetails> {
    private static final SdkField<List<String>> PROCESSING_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("processingTargets")
            .getter(getter(JobProcessDetails::processingTargets))
            .setter(setter(Builder::processingTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_CANCELED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfCanceledThings").getter(getter(JobProcessDetails::numberOfCanceledThings))
            .setter(setter(Builder::numberOfCanceledThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfCanceledThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SUCCEEDED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfSucceededThings").getter(getter(JobProcessDetails::numberOfSucceededThings))
            .setter(setter(Builder::numberOfSucceededThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSucceededThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_FAILED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfFailedThings").getter(getter(JobProcessDetails::numberOfFailedThings))
            .setter(setter(Builder::numberOfFailedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfFailedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_REJECTED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRejectedThings").getter(getter(JobProcessDetails::numberOfRejectedThings))
            .setter(setter(Builder::numberOfRejectedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRejectedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_QUEUED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfQueuedThings").getter(getter(JobProcessDetails::numberOfQueuedThings))
            .setter(setter(Builder::numberOfQueuedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfQueuedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_IN_PROGRESS_THINGS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("numberOfInProgressThings")
            .getter(getter(JobProcessDetails::numberOfInProgressThings)).setter(setter(Builder::numberOfInProgressThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfInProgressThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_REMOVED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRemovedThings").getter(getter(JobProcessDetails::numberOfRemovedThings))
            .setter(setter(Builder::numberOfRemovedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRemovedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_TIMED_OUT_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfTimedOutThings").getter(getter(JobProcessDetails::numberOfTimedOutThings))
            .setter(setter(Builder::numberOfTimedOutThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTimedOutThings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_TARGETS_FIELD,
            NUMBER_OF_CANCELED_THINGS_FIELD, NUMBER_OF_SUCCEEDED_THINGS_FIELD, NUMBER_OF_FAILED_THINGS_FIELD,
            NUMBER_OF_REJECTED_THINGS_FIELD, NUMBER_OF_QUEUED_THINGS_FIELD, NUMBER_OF_IN_PROGRESS_THINGS_FIELD,
            NUMBER_OF_REMOVED_THINGS_FIELD, NUMBER_OF_TIMED_OUT_THINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> processingTargets;

    private final Integer numberOfCanceledThings;

    private final Integer numberOfSucceededThings;

    private final Integer numberOfFailedThings;

    private final Integer numberOfRejectedThings;

    private final Integer numberOfQueuedThings;

    private final Integer numberOfInProgressThings;

    private final Integer numberOfRemovedThings;

    private final Integer numberOfTimedOutThings;

    private JobProcessDetails(BuilderImpl builder) {
        this.processingTargets = builder.processingTargets;
        this.numberOfCanceledThings = builder.numberOfCanceledThings;
        this.numberOfSucceededThings = builder.numberOfSucceededThings;
        this.numberOfFailedThings = builder.numberOfFailedThings;
        this.numberOfRejectedThings = builder.numberOfRejectedThings;
        this.numberOfQueuedThings = builder.numberOfQueuedThings;
        this.numberOfInProgressThings = builder.numberOfInProgressThings;
        this.numberOfRemovedThings = builder.numberOfRemovedThings;
        this.numberOfTimedOutThings = builder.numberOfTimedOutThings;
    }

    /**
     * Returns true if the ProcessingTargets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProcessingTargets() {
        return processingTargets != null && !(processingTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target devices to which the job execution is being rolled out. This value will be null after the job
     * execution has finished rolling out to all the target devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessingTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The target devices to which the job execution is being rolled out. This value will be null after the job
     *         execution has finished rolling out to all the target devices.
     */
    public final List<String> processingTargets() {
        return processingTargets;
    }

    /**
     * <p>
     * The number of things that cancelled the job.
     * </p>
     * 
     * @return The number of things that cancelled the job.
     */
    public final Integer numberOfCanceledThings() {
        return numberOfCanceledThings;
    }

    /**
     * <p>
     * The number of things which successfully completed the job.
     * </p>
     * 
     * @return The number of things which successfully completed the job.
     */
    public final Integer numberOfSucceededThings() {
        return numberOfSucceededThings;
    }

    /**
     * <p>
     * The number of things that failed executing the job.
     * </p>
     * 
     * @return The number of things that failed executing the job.
     */
    public final Integer numberOfFailedThings() {
        return numberOfFailedThings;
    }

    /**
     * <p>
     * The number of things that rejected the job.
     * </p>
     * 
     * @return The number of things that rejected the job.
     */
    public final Integer numberOfRejectedThings() {
        return numberOfRejectedThings;
    }

    /**
     * <p>
     * The number of things that are awaiting execution of the job.
     * </p>
     * 
     * @return The number of things that are awaiting execution of the job.
     */
    public final Integer numberOfQueuedThings() {
        return numberOfQueuedThings;
    }

    /**
     * <p>
     * The number of things currently executing the job.
     * </p>
     * 
     * @return The number of things currently executing the job.
     */
    public final Integer numberOfInProgressThings() {
        return numberOfInProgressThings;
    }

    /**
     * <p>
     * The number of things that are no longer scheduled to execute the job because they have been deleted or have been
     * removed from the group that was a target of the job.
     * </p>
     * 
     * @return The number of things that are no longer scheduled to execute the job because they have been deleted or
     *         have been removed from the group that was a target of the job.
     */
    public final Integer numberOfRemovedThings() {
        return numberOfRemovedThings;
    }

    /**
     * <p>
     * The number of things whose job execution status is <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return The number of things whose job execution status is <code>TIMED_OUT</code>.
     */
    public final Integer numberOfTimedOutThings() {
        return numberOfTimedOutThings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessingTargets() ? processingTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCanceledThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSucceededThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFailedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRejectedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfQueuedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfInProgressThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRemovedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTimedOutThings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProcessDetails)) {
            return false;
        }
        JobProcessDetails other = (JobProcessDetails) obj;
        return hasProcessingTargets() == other.hasProcessingTargets()
                && Objects.equals(processingTargets(), other.processingTargets())
                && Objects.equals(numberOfCanceledThings(), other.numberOfCanceledThings())
                && Objects.equals(numberOfSucceededThings(), other.numberOfSucceededThings())
                && Objects.equals(numberOfFailedThings(), other.numberOfFailedThings())
                && Objects.equals(numberOfRejectedThings(), other.numberOfRejectedThings())
                && Objects.equals(numberOfQueuedThings(), other.numberOfQueuedThings())
                && Objects.equals(numberOfInProgressThings(), other.numberOfInProgressThings())
                && Objects.equals(numberOfRemovedThings(), other.numberOfRemovedThings())
                && Objects.equals(numberOfTimedOutThings(), other.numberOfTimedOutThings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobProcessDetails")
                .add("ProcessingTargets", hasProcessingTargets() ? processingTargets() : null)
                .add("NumberOfCanceledThings", numberOfCanceledThings())
                .add("NumberOfSucceededThings", numberOfSucceededThings()).add("NumberOfFailedThings", numberOfFailedThings())
                .add("NumberOfRejectedThings", numberOfRejectedThings()).add("NumberOfQueuedThings", numberOfQueuedThings())
                .add("NumberOfInProgressThings", numberOfInProgressThings())
                .add("NumberOfRemovedThings", numberOfRemovedThings()).add("NumberOfTimedOutThings", numberOfTimedOutThings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "processingTargets":
            return Optional.ofNullable(clazz.cast(processingTargets()));
        case "numberOfCanceledThings":
            return Optional.ofNullable(clazz.cast(numberOfCanceledThings()));
        case "numberOfSucceededThings":
            return Optional.ofNullable(clazz.cast(numberOfSucceededThings()));
        case "numberOfFailedThings":
            return Optional.ofNullable(clazz.cast(numberOfFailedThings()));
        case "numberOfRejectedThings":
            return Optional.ofNullable(clazz.cast(numberOfRejectedThings()));
        case "numberOfQueuedThings":
            return Optional.ofNullable(clazz.cast(numberOfQueuedThings()));
        case "numberOfInProgressThings":
            return Optional.ofNullable(clazz.cast(numberOfInProgressThings()));
        case "numberOfRemovedThings":
            return Optional.ofNullable(clazz.cast(numberOfRemovedThings()));
        case "numberOfTimedOutThings":
            return Optional.ofNullable(clazz.cast(numberOfTimedOutThings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobProcessDetails, T> g) {
        return obj -> g.apply((JobProcessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobProcessDetails> {
        /**
         * <p>
         * The target devices to which the job execution is being rolled out. This value will be null after the job
         * execution has finished rolling out to all the target devices.
         * </p>
         * 
         * @param processingTargets
         *        The target devices to which the job execution is being rolled out. This value will be null after the
         *        job execution has finished rolling out to all the target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTargets(Collection<String> processingTargets);

        /**
         * <p>
         * The target devices to which the job execution is being rolled out. This value will be null after the job
         * execution has finished rolling out to all the target devices.
         * </p>
         * 
         * @param processingTargets
         *        The target devices to which the job execution is being rolled out. This value will be null after the
         *        job execution has finished rolling out to all the target devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTargets(String... processingTargets);

        /**
         * <p>
         * The number of things that cancelled the job.
         * </p>
         * 
         * @param numberOfCanceledThings
         *        The number of things that cancelled the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCanceledThings(Integer numberOfCanceledThings);

        /**
         * <p>
         * The number of things which successfully completed the job.
         * </p>
         * 
         * @param numberOfSucceededThings
         *        The number of things which successfully completed the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSucceededThings(Integer numberOfSucceededThings);

        /**
         * <p>
         * The number of things that failed executing the job.
         * </p>
         * 
         * @param numberOfFailedThings
         *        The number of things that failed executing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFailedThings(Integer numberOfFailedThings);

        /**
         * <p>
         * The number of things that rejected the job.
         * </p>
         * 
         * @param numberOfRejectedThings
         *        The number of things that rejected the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRejectedThings(Integer numberOfRejectedThings);

        /**
         * <p>
         * The number of things that are awaiting execution of the job.
         * </p>
         * 
         * @param numberOfQueuedThings
         *        The number of things that are awaiting execution of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfQueuedThings(Integer numberOfQueuedThings);

        /**
         * <p>
         * The number of things currently executing the job.
         * </p>
         * 
         * @param numberOfInProgressThings
         *        The number of things currently executing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfInProgressThings(Integer numberOfInProgressThings);

        /**
         * <p>
         * The number of things that are no longer scheduled to execute the job because they have been deleted or have
         * been removed from the group that was a target of the job.
         * </p>
         * 
         * @param numberOfRemovedThings
         *        The number of things that are no longer scheduled to execute the job because they have been deleted or
         *        have been removed from the group that was a target of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRemovedThings(Integer numberOfRemovedThings);

        /**
         * <p>
         * The number of things whose job execution status is <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param numberOfTimedOutThings
         *        The number of things whose job execution status is <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTimedOutThings(Integer numberOfTimedOutThings);
    }

    static final class BuilderImpl implements Builder {
        private List<String> processingTargets = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfCanceledThings;

        private Integer numberOfSucceededThings;

        private Integer numberOfFailedThings;

        private Integer numberOfRejectedThings;

        private Integer numberOfQueuedThings;

        private Integer numberOfInProgressThings;

        private Integer numberOfRemovedThings;

        private Integer numberOfTimedOutThings;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProcessDetails model) {
            processingTargets(model.processingTargets);
            numberOfCanceledThings(model.numberOfCanceledThings);
            numberOfSucceededThings(model.numberOfSucceededThings);
            numberOfFailedThings(model.numberOfFailedThings);
            numberOfRejectedThings(model.numberOfRejectedThings);
            numberOfQueuedThings(model.numberOfQueuedThings);
            numberOfInProgressThings(model.numberOfInProgressThings);
            numberOfRemovedThings(model.numberOfRemovedThings);
            numberOfTimedOutThings(model.numberOfTimedOutThings);
        }

        public final Collection<String> getProcessingTargets() {
            if (processingTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return processingTargets;
        }

        @Override
        public final Builder processingTargets(Collection<String> processingTargets) {
            this.processingTargets = ProcessingTargetNameListCopier.copy(processingTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingTargets(String... processingTargets) {
            processingTargets(Arrays.asList(processingTargets));
            return this;
        }

        public final void setProcessingTargets(Collection<String> processingTargets) {
            this.processingTargets = ProcessingTargetNameListCopier.copy(processingTargets);
        }

        public final Integer getNumberOfCanceledThings() {
            return numberOfCanceledThings;
        }

        @Override
        public final Builder numberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
            return this;
        }

        public final void setNumberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
        }

        public final Integer getNumberOfSucceededThings() {
            return numberOfSucceededThings;
        }

        @Override
        public final Builder numberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
            return this;
        }

        public final void setNumberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
        }

        public final Integer getNumberOfFailedThings() {
            return numberOfFailedThings;
        }

        @Override
        public final Builder numberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
            return this;
        }

        public final void setNumberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
        }

        public final Integer getNumberOfRejectedThings() {
            return numberOfRejectedThings;
        }

        @Override
        public final Builder numberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
            return this;
        }

        public final void setNumberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
        }

        public final Integer getNumberOfQueuedThings() {
            return numberOfQueuedThings;
        }

        @Override
        public final Builder numberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
            return this;
        }

        public final void setNumberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
        }

        public final Integer getNumberOfInProgressThings() {
            return numberOfInProgressThings;
        }

        @Override
        public final Builder numberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
            return this;
        }

        public final void setNumberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
        }

        public final Integer getNumberOfRemovedThings() {
            return numberOfRemovedThings;
        }

        @Override
        public final Builder numberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
            return this;
        }

        public final void setNumberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
        }

        public final Integer getNumberOfTimedOutThings() {
            return numberOfTimedOutThings;
        }

        @Override
        public final Builder numberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
            return this;
        }

        public final void setNumberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
        }

        @Override
        public JobProcessDetails build() {
            return new JobProcessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
