/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to send data from an MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotSiteWiseAction implements SdkPojo, Serializable,
        ToCopyableBuilder<IotSiteWiseAction.Builder, IotSiteWiseAction> {
    private static final SdkField<List<PutAssetPropertyValueEntry>> PUT_ASSET_PROPERTY_VALUE_ENTRIES_FIELD = SdkField
            .<List<PutAssetPropertyValueEntry>> builder(MarshallingType.LIST)
            .memberName("putAssetPropertyValueEntries")
            .getter(getter(IotSiteWiseAction::putAssetPropertyValueEntries))
            .setter(setter(Builder::putAssetPropertyValueEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putAssetPropertyValueEntries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutAssetPropertyValueEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutAssetPropertyValueEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(IotSiteWiseAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUT_ASSET_PROPERTY_VALUE_ENTRIES_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries;

    private final String roleArn;

    private IotSiteWiseAction(BuilderImpl builder) {
        this.putAssetPropertyValueEntries = builder.putAssetPropertyValueEntries;
        this.roleArn = builder.roleArn;
    }

    /**
     * Returns true if the PutAssetPropertyValueEntries property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasPutAssetPropertyValueEntries() {
        return putAssetPropertyValueEntries != null && !(putAssetPropertyValueEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset property value entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPutAssetPropertyValueEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of asset property value entries.
     */
    public final List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries() {
        return putAssetPropertyValueEntries;
    }

    /**
     * <p>
     * The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise. (
     * <code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict access to
     * specific asset hierarchy paths.
     * </p>
     * 
     * @return The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise. (
     *         <code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict access to
     *         specific asset hierarchy paths.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPutAssetPropertyValueEntries() ? putAssetPropertyValueEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseAction)) {
            return false;
        }
        IotSiteWiseAction other = (IotSiteWiseAction) obj;
        return hasPutAssetPropertyValueEntries() == other.hasPutAssetPropertyValueEntries()
                && Objects.equals(putAssetPropertyValueEntries(), other.putAssetPropertyValueEntries())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotSiteWiseAction")
                .add("PutAssetPropertyValueEntries", hasPutAssetPropertyValueEntries() ? putAssetPropertyValueEntries() : null)
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "putAssetPropertyValueEntries":
            return Optional.ofNullable(clazz.cast(putAssetPropertyValueEntries()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseAction, T> g) {
        return obj -> g.apply((IotSiteWiseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotSiteWiseAction> {
        /**
         * <p>
         * A list of asset property value entries.
         * </p>
         * 
         * @param putAssetPropertyValueEntries
         *        A list of asset property value entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putAssetPropertyValueEntries(Collection<PutAssetPropertyValueEntry> putAssetPropertyValueEntries);

        /**
         * <p>
         * A list of asset property value entries.
         * </p>
         * 
         * @param putAssetPropertyValueEntries
         *        A list of asset property value entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putAssetPropertyValueEntries(PutAssetPropertyValueEntry... putAssetPropertyValueEntries);

        /**
         * <p>
         * A list of asset property value entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutAssetPropertyValueEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PutAssetPropertyValueEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutAssetPropertyValueEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #putAssetPropertyValueEntries(List<PutAssetPropertyValueEntry>)}.
         * 
         * @param putAssetPropertyValueEntries
         *        a consumer that will call methods on {@link List<PutAssetPropertyValueEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #putAssetPropertyValueEntries(List<PutAssetPropertyValueEntry>)
         */
        Builder putAssetPropertyValueEntries(Consumer<PutAssetPropertyValueEntry.Builder>... putAssetPropertyValueEntries);

        /**
         * <p>
         * The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise. (
         * <code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict access to
         * specific asset hierarchy paths.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise.
         *        (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict
         *        access to specific asset hierarchy paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<PutAssetPropertyValueEntry> putAssetPropertyValueEntries = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseAction model) {
            putAssetPropertyValueEntries(model.putAssetPropertyValueEntries);
            roleArn(model.roleArn);
        }

        public final Collection<PutAssetPropertyValueEntry.Builder> getPutAssetPropertyValueEntries() {
            if (putAssetPropertyValueEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return putAssetPropertyValueEntries != null ? putAssetPropertyValueEntries.stream()
                    .map(PutAssetPropertyValueEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder putAssetPropertyValueEntries(Collection<PutAssetPropertyValueEntry> putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries = PutAssetPropertyValueEntryListCopier.copy(putAssetPropertyValueEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putAssetPropertyValueEntries(PutAssetPropertyValueEntry... putAssetPropertyValueEntries) {
            putAssetPropertyValueEntries(Arrays.asList(putAssetPropertyValueEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder putAssetPropertyValueEntries(
                Consumer<PutAssetPropertyValueEntry.Builder>... putAssetPropertyValueEntries) {
            putAssetPropertyValueEntries(Stream.of(putAssetPropertyValueEntries)
                    .map(c -> PutAssetPropertyValueEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPutAssetPropertyValueEntries(
                Collection<PutAssetPropertyValueEntry.BuilderImpl> putAssetPropertyValueEntries) {
            this.putAssetPropertyValueEntries = PutAssetPropertyValueEntryListCopier
                    .copyFromBuilder(putAssetPropertyValueEntries);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public IotSiteWiseAction build() {
            return new IotSiteWiseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
