/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters used when defining a mitigation action that enable AWS IoT logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableIoTLoggingParams implements SdkPojo, Serializable,
        ToCopyableBuilder<EnableIoTLoggingParams.Builder, EnableIoTLoggingParams> {
    private static final SdkField<String> ROLE_ARN_FOR_LOGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArnForLogging").getter(getter(EnableIoTLoggingParams::roleArnForLogging))
            .setter(setter(Builder::roleArnForLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArnForLogging").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(EnableIoTLoggingParams::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FOR_LOGGING_FIELD,
            LOG_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArnForLogging;

    private final String logLevel;

    private EnableIoTLoggingParams(BuilderImpl builder) {
        this.roleArnForLogging = builder.roleArnForLogging;
        this.logLevel = builder.logLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used for logging.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used for logging.
     */
    public final String roleArnForLogging() {
        return roleArnForLogging;
    }

    /**
     * <p>
     * Specifies the type of information to be logged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Specifies the type of information to be logged.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * Specifies the type of information to be logged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Specifies the type of information to be logged.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArnForLogging());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableIoTLoggingParams)) {
            return false;
        }
        EnableIoTLoggingParams other = (EnableIoTLoggingParams) obj;
        return Objects.equals(roleArnForLogging(), other.roleArnForLogging())
                && Objects.equals(logLevelAsString(), other.logLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableIoTLoggingParams").add("RoleArnForLogging", roleArnForLogging())
                .add("LogLevel", logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArnForLogging":
            return Optional.ofNullable(clazz.cast(roleArnForLogging()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableIoTLoggingParams, T> g) {
        return obj -> g.apply((EnableIoTLoggingParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnableIoTLoggingParams> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used for logging.
         * </p>
         * 
         * @param roleArnForLogging
         *        The Amazon Resource Name (ARN) of the IAM role used for logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArnForLogging(String roleArnForLogging);

        /**
         * <p>
         * Specifies the type of information to be logged.
         * </p>
         * 
         * @param logLevel
         *        Specifies the type of information to be logged.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * Specifies the type of information to be logged.
         * </p>
         * 
         * @param logLevel
         *        Specifies the type of information to be logged.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);
    }

    static final class BuilderImpl implements Builder {
        private String roleArnForLogging;

        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableIoTLoggingParams model) {
            roleArnForLogging(model.roleArnForLogging);
            logLevel(model.logLevel);
        }

        public final String getRoleArnForLogging() {
            return roleArnForLogging;
        }

        @Override
        public final Builder roleArnForLogging(String roleArnForLogging) {
            this.roleArnForLogging = roleArnForLogging;
            return this;
        }

        public final void setRoleArnForLogging(String roleArnForLogging) {
            this.roleArnForLogging = roleArnForLogging;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public EnableIoTLoggingParams build() {
            return new EnableIoTLoggingParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
