/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes which mitigation actions should be executed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectMitigationActionExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectMitigationActionExecution.Builder, DetectMitigationActionExecution> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(DetectMitigationActionExecution::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(DetectMitigationActionExecution::violationId))
            .setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(DetectMitigationActionExecution::actionName))
            .setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(DetectMitigationActionExecution::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<Instant> EXECUTION_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionStartDate").getter(getter(DetectMitigationActionExecution::executionStartDate))
            .setter(setter(Builder::executionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartDate").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionEndDate").getter(getter(DetectMitigationActionExecution::executionEndDate))
            .setter(setter(Builder::executionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEndDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DetectMitigationActionExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(DetectMitigationActionExecution::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DetectMitigationActionExecution::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            VIOLATION_ID_FIELD, ACTION_NAME_FIELD, THING_NAME_FIELD, EXECUTION_START_DATE_FIELD, EXECUTION_END_DATE_FIELD,
            STATUS_FIELD, ERROR_CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String violationId;

    private final String actionName;

    private final String thingName;

    private final Instant executionStartDate;

    private final Instant executionEndDate;

    private final String status;

    private final String errorCode;

    private final String message;

    private DetectMitigationActionExecution(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.violationId = builder.violationId;
        this.actionName = builder.actionName;
        this.thingName = builder.thingName;
        this.executionStartDate = builder.executionStartDate;
        this.executionEndDate = builder.executionEndDate;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The unique identifier of the task.
     * </p>
     * 
     * @return The unique identifier of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The unique identifier of the violation.
     * </p>
     * 
     * @return The unique identifier of the violation.
     */
    public final String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The friendly name that uniquely identifies the mitigation action.
     * </p>
     * 
     * @return The friendly name that uniquely identifies the mitigation action.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The date a mitigation action was started.
     * </p>
     * 
     * @return The date a mitigation action was started.
     */
    public final Instant executionStartDate() {
        return executionStartDate;
    }

    /**
     * <p>
     * The date a mitigation action ended.
     * </p>
     * 
     * @return The date a mitigation action ended.
     */
    public final Instant executionEndDate() {
        return executionEndDate;
    }

    /**
     * <p>
     * The status of a mitigation action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectMitigationActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a mitigation action.
     * @see DetectMitigationActionExecutionStatus
     */
    public final DetectMitigationActionExecutionStatus status() {
        return DetectMitigationActionExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a mitigation action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectMitigationActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a mitigation action.
     * @see DetectMitigationActionExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error code of a mitigation action.
     * </p>
     * 
     * @return The error code of a mitigation action.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The message of a mitigation action.
     * </p>
     * 
     * @return The message of a mitigation action.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionExecution)) {
            return false;
        }
        DetectMitigationActionExecution other = (DetectMitigationActionExecution) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(violationId(), other.violationId())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(executionStartDate(), other.executionStartDate())
                && Objects.equals(executionEndDate(), other.executionEndDate())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectMitigationActionExecution").add("TaskId", taskId()).add("ViolationId", violationId())
                .add("ActionName", actionName()).add("ThingName", thingName()).add("ExecutionStartDate", executionStartDate())
                .add("ExecutionEndDate", executionEndDate()).add("Status", statusAsString()).add("ErrorCode", errorCode())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "executionStartDate":
            return Optional.ofNullable(clazz.cast(executionStartDate()));
        case "executionEndDate":
            return Optional.ofNullable(clazz.cast(executionEndDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionExecution, T> g) {
        return obj -> g.apply((DetectMitigationActionExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectMitigationActionExecution> {
        /**
         * <p>
         * The unique identifier of the task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The unique identifier of the violation.
         * </p>
         * 
         * @param violationId
         *        The unique identifier of the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The friendly name that uniquely identifies the mitigation action.
         * </p>
         * 
         * @param actionName
         *        The friendly name that uniquely identifies the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The date a mitigation action was started.
         * </p>
         * 
         * @param executionStartDate
         *        The date a mitigation action was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartDate(Instant executionStartDate);

        /**
         * <p>
         * The date a mitigation action ended.
         * </p>
         * 
         * @param executionEndDate
         *        The date a mitigation action ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndDate(Instant executionEndDate);

        /**
         * <p>
         * The status of a mitigation action.
         * </p>
         * 
         * @param status
         *        The status of a mitigation action.
         * @see DetectMitigationActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectMitigationActionExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a mitigation action.
         * </p>
         * 
         * @param status
         *        The status of a mitigation action.
         * @see DetectMitigationActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectMitigationActionExecutionStatus
         */
        Builder status(DetectMitigationActionExecutionStatus status);

        /**
         * <p>
         * The error code of a mitigation action.
         * </p>
         * 
         * @param errorCode
         *        The error code of a mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The message of a mitigation action.
         * </p>
         * 
         * @param message
         *        The message of a mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String violationId;

        private String actionName;

        private String thingName;

        private Instant executionStartDate;

        private Instant executionEndDate;

        private String status;

        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionExecution model) {
            taskId(model.taskId);
            violationId(model.violationId);
            actionName(model.actionName);
            thingName(model.thingName);
            executionStartDate(model.executionStartDate);
            executionEndDate(model.executionEndDate);
            status(model.status);
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getViolationId() {
            return violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Instant getExecutionStartDate() {
            return executionStartDate;
        }

        @Override
        public final Builder executionStartDate(Instant executionStartDate) {
            this.executionStartDate = executionStartDate;
            return this;
        }

        public final void setExecutionStartDate(Instant executionStartDate) {
            this.executionStartDate = executionStartDate;
        }

        public final Instant getExecutionEndDate() {
            return executionEndDate;
        }

        @Override
        public final Builder executionEndDate(Instant executionEndDate) {
            this.executionEndDate = executionEndDate;
            return this;
        }

        public final void setExecutionEndDate(Instant executionEndDate) {
            this.executionEndDate = executionEndDate;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectMitigationActionExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public DetectMitigationActionExecution build() {
            return new DetectMitigationActionExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
