/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that updates a CloudWatch alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudwatchAlarmAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudwatchAlarmAction.Builder, CloudwatchAlarmAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CloudwatchAlarmAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmName").getter(getter(CloudwatchAlarmAction::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateReason").getter(getter(CloudwatchAlarmAction::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateReason").build()).build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateValue").getter(getter(CloudwatchAlarmAction::stateValue)).setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            ALARM_NAME_FIELD, STATE_REASON_FIELD, STATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String alarmName;

    private final String stateReason;

    private final String stateValue;

    private CloudwatchAlarmAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.alarmName = builder.alarmName;
        this.stateReason = builder.stateReason;
        this.stateValue = builder.stateValue;
    }

    /**
     * <p>
     * The IAM role that allows access to the CloudWatch alarm.
     * </p>
     * 
     * @return The IAM role that allows access to the CloudWatch alarm.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The CloudWatch alarm name.
     * </p>
     * 
     * @return The CloudWatch alarm name.
     */
    public final String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The reason for the alarm change.
     * </p>
     * 
     * @return The reason for the alarm change.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     * </p>
     * 
     * @return The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     */
    public final String stateValue() {
        return stateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchAlarmAction)) {
            return false;
        }
        CloudwatchAlarmAction other = (CloudwatchAlarmAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(stateValue(), other.stateValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudwatchAlarmAction").add("RoleArn", roleArn()).add("AlarmName", alarmName())
                .add("StateReason", stateReason()).add("StateValue", stateValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "alarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "stateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "stateValue":
            return Optional.ofNullable(clazz.cast(stateValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchAlarmAction, T> g) {
        return obj -> g.apply((CloudwatchAlarmAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudwatchAlarmAction> {
        /**
         * <p>
         * The IAM role that allows access to the CloudWatch alarm.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that allows access to the CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The CloudWatch alarm name.
         * </p>
         * 
         * @param alarmName
         *        The CloudWatch alarm name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The reason for the alarm change.
         * </p>
         * 
         * @param stateReason
         *        The reason for the alarm change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         * </p>
         * 
         * @param stateValue
         *        The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateValue(String stateValue);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String alarmName;

        private String stateReason;

        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchAlarmAction model) {
            roleArn(model.roleArn);
            alarmName(model.alarmName);
            stateReason(model.stateReason);
            stateValue(model.stateValue);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public CloudwatchAlarmAction build() {
            return new CloudwatchAlarmAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
