/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummariesCopier;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTopicRuleDestinationsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListTopicRuleDestinationsResponse> {
    private static final SdkField<List<TopicRuleDestinationSummary>> DESTINATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationSummaries").getter(ListTopicRuleDestinationsResponse.getter(ListTopicRuleDestinationsResponse::destinationSummaries)).setter(ListTopicRuleDestinationsResponse.setter(Builder::destinationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicRuleDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTopicRuleDestinationsResponse.getter(ListTopicRuleDestinationsResponse::nextToken)).setter(ListTopicRuleDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TopicRuleDestinationSummary> destinationSummaries;
    private final String nextToken;

    private ListTopicRuleDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.destinationSummaries = builder.destinationSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDestinationSummaries() {
        return this.destinationSummaries != null && !(this.destinationSummaries instanceof SdkAutoConstructList);
    }

    public List<TopicRuleDestinationSummary> destinationSummaries() {
        return this.destinationSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRuleDestinationsResponse)) {
            return false;
        }
        ListTopicRuleDestinationsResponse other = (ListTopicRuleDestinationsResponse)((Object)obj);
        return Objects.equals(this.destinationSummaries(), other.destinationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTopicRuleDestinationsResponse").add("DestinationSummaries", this.destinationSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationSummaries": {
                return Optional.ofNullable(clazz.cast(this.destinationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTopicRuleDestinationsResponse, T> g) {
        return obj -> g.apply((ListTopicRuleDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<TopicRuleDestinationSummary> destinationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRuleDestinationsResponse model) {
            super(model);
            this.destinationSummaries(model.destinationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<TopicRuleDestinationSummary.Builder> getDestinationSummaries() {
            return this.destinationSummaries != null ? (Collection)this.destinationSummaries.stream().map(TopicRuleDestinationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationSummaries(Collection<TopicRuleDestinationSummary> destinationSummaries) {
            this.destinationSummaries = TopicRuleDestinationSummariesCopier.copy(destinationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationSummaries(TopicRuleDestinationSummary ... destinationSummaries) {
            this.destinationSummaries(Arrays.asList(destinationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationSummaries(Consumer<TopicRuleDestinationSummary.Builder> ... destinationSummaries) {
            this.destinationSummaries(Stream.of(destinationSummaries).map(c -> (TopicRuleDestinationSummary)((TopicRuleDestinationSummary.Builder)TopicRuleDestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationSummaries(Collection<TopicRuleDestinationSummary.BuilderImpl> destinationSummaries) {
            this.destinationSummaries = TopicRuleDestinationSummariesCopier.copyFromBuilder(destinationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicRuleDestinationsResponse build() {
            return new ListTopicRuleDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTopicRuleDestinationsResponse> {
        public Builder destinationSummaries(Collection<TopicRuleDestinationSummary> var1);

        public Builder destinationSummaries(TopicRuleDestinationSummary ... var1);

        public Builder destinationSummaries(Consumer<TopicRuleDestinationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

