/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileIdentifier>> SECURITY_PROFILE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityProfileIdentifiers").getter(ListSecurityProfilesResponse.getter(ListSecurityProfilesResponse::securityProfileIdentifiers)).setter(ListSecurityProfilesResponse.setter(Builder::securityProfileIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSecurityProfilesResponse.getter(ListSecurityProfilesResponse::nextToken)).setter(ListSecurityProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SecurityProfileIdentifier> securityProfileIdentifiers;
    private final String nextToken;

    private ListSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileIdentifiers = builder.securityProfileIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSecurityProfileIdentifiers() {
        return this.securityProfileIdentifiers != null && !(this.securityProfileIdentifiers instanceof SdkAutoConstructList);
    }

    public List<SecurityProfileIdentifier> securityProfileIdentifiers() {
        return this.securityProfileIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesResponse)) {
            return false;
        }
        ListSecurityProfilesResponse other = (ListSecurityProfilesResponse)((Object)obj);
        return Objects.equals(this.securityProfileIdentifiers(), other.securityProfileIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSecurityProfilesResponse").add("SecurityProfileIdentifiers", this.securityProfileIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIdentifiers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileIdentifier> securityProfileIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesResponse model) {
            super(model);
            this.securityProfileIdentifiers(model.securityProfileIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileIdentifier.Builder> getSecurityProfileIdentifiers() {
            return this.securityProfileIdentifiers != null ? (Collection)this.securityProfileIdentifiers.stream().map(SecurityProfileIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copy(securityProfileIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(SecurityProfileIdentifier ... securityProfileIdentifiers) {
            this.securityProfileIdentifiers(Arrays.asList(securityProfileIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder> ... securityProfileIdentifiers) {
            this.securityProfileIdentifiers(Stream.of(securityProfileIdentifiers).map(c -> (SecurityProfileIdentifier)((SecurityProfileIdentifier.Builder)SecurityProfileIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileIdentifiers(Collection<SecurityProfileIdentifier.BuilderImpl> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copyFromBuilder(securityProfileIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityProfilesResponse build() {
            return new ListSecurityProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfilesResponse> {
        public Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> var1);

        public Builder securityProfileIdentifiers(SecurityProfileIdentifier ... var1);

        public Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

