/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadata;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadataListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditTasksResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuditTasksResponse> {
    private static final SdkField<List<AuditTaskMetadata>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(ListAuditTasksResponse.getter(ListAuditTasksResponse::tasks)).setter(ListAuditTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditTaskMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditTasksResponse.getter(ListAuditTasksResponse::nextToken)).setter(ListAuditTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AuditTaskMetadata> tasks;
    private final String nextToken;

    private ListAuditTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public List<AuditTaskMetadata> tasks() {
        return this.tasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditTasksResponse)) {
            return false;
        }
        ListAuditTasksResponse other = (ListAuditTasksResponse)((Object)obj);
        return Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAuditTasksResponse").add("Tasks", this.tasks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditTasksResponse, T> g) {
        return obj -> g.apply((ListAuditTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuditTaskMetadata> tasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<AuditTaskMetadata.Builder> getTasks() {
            return this.tasks != null ? (Collection)this.tasks.stream().map(AuditTaskMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<AuditTaskMetadata> tasks) {
            this.tasks = AuditTaskMetadataListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(AuditTaskMetadata ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<AuditTaskMetadata.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (AuditTaskMetadata)((AuditTaskMetadata.Builder)AuditTaskMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<AuditTaskMetadata.BuilderImpl> tasks) {
            this.tasks = AuditTaskMetadataListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAuditTasksResponse build() {
            return new ListAuditTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditTasksResponse> {
        public Builder tasks(Collection<AuditTaskMetadata> var1);

        public Builder tasks(AuditTaskMetadata ... var1);

        public Builder tasks(Consumer<AuditTaskMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

