/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.ThingGroupProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDynamicThingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateDynamicThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingGroupName").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::thingGroupName)).setter(CreateDynamicThingGroupRequest.setter(Builder::thingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingGroupName").build()}).build();
    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("thingGroupProperties").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::thingGroupProperties)).setter(CreateDynamicThingGroupRequest.setter(Builder::thingGroupProperties)).constructor(ThingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::indexName)).setter(CreateDynamicThingGroupRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::queryString)).setter(CreateDynamicThingGroupRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryVersion").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::queryVersion)).setter(CreateDynamicThingGroupRequest.setter(Builder::queryVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDynamicThingGroupRequest.getter(CreateDynamicThingGroupRequest::tags)).setter(CreateDynamicThingGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD, THING_GROUP_PROPERTIES_FIELD, INDEX_NAME_FIELD, QUERY_STRING_FIELD, QUERY_VERSION_FIELD, TAGS_FIELD));
    private final String thingGroupName;
    private final ThingGroupProperties thingGroupProperties;
    private final String indexName;
    private final String queryString;
    private final String queryVersion;
    private final List<Tag> tags;

    private CreateDynamicThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.queryVersion = builder.queryVersion;
        this.tags = builder.tags;
    }

    public final String thingGroupName() {
        return this.thingGroupName;
    }

    public final ThingGroupProperties thingGroupProperties() {
        return this.thingGroupProperties;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String queryVersion() {
        return this.queryVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDynamicThingGroupRequest)) {
            return false;
        }
        CreateDynamicThingGroupRequest other = (CreateDynamicThingGroupRequest)((Object)obj);
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupProperties(), other.thingGroupProperties()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.queryVersion(), other.queryVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDynamicThingGroupRequest").add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupProperties", (Object)this.thingGroupProperties()).add("IndexName", (Object)this.indexName()).add("QueryString", (Object)this.queryString()).add("QueryVersion", (Object)this.queryVersion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.thingGroupProperties()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDynamicThingGroupRequest, T> g) {
        return obj -> g.apply((CreateDynamicThingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingGroupName;
        private ThingGroupProperties thingGroupProperties;
        private String indexName;
        private String queryString;
        private String queryVersion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDynamicThingGroupRequest model) {
            super(model);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupProperties(model.thingGroupProperties);
            this.indexName(model.indexName);
            this.queryString(model.queryString);
            this.queryVersion(model.queryVersion);
            this.tags(model.tags);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return this.thingGroupProperties != null ? this.thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDynamicThingGroupRequest build() {
            return new CreateDynamicThingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDynamicThingGroupRequest> {
        public Builder thingGroupName(String var1);

        public Builder thingGroupProperties(ThingGroupProperties var1);

        default public Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return this.thingGroupProperties((ThingGroupProperties)((ThingGroupProperties.Builder)ThingGroupProperties.builder().applyMutation(thingGroupProperties)).build());
        }

        public Builder indexName(String var1);

        public Builder queryString(String var1);

        public Builder queryVersion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

