/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.BehaviorCriteriaType;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActiveViolationsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListActiveViolationsRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::thingName)).setter(ListActiveViolationsRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::securityProfileName)).setter(ListActiveViolationsRequest.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> BEHAVIOR_CRITERIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("behaviorCriteriaType").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::behaviorCriteriaTypeAsString)).setter(ListActiveViolationsRequest.setter(Builder::behaviorCriteriaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("behaviorCriteriaType").build()}).build();
    private static final SdkField<Boolean> LIST_SUPPRESSED_ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("listSuppressedAlerts").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::listSuppressedAlerts)).setter(ListActiveViolationsRequest.setter(Builder::listSuppressedAlerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("listSuppressedAlerts").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::nextToken)).setter(ListActiveViolationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListActiveViolationsRequest.getter(ListActiveViolationsRequest::maxResults)).setter(ListActiveViolationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_CRITERIA_TYPE_FIELD, LIST_SUPPRESSED_ALERTS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String thingName;
    private final String securityProfileName;
    private final String behaviorCriteriaType;
    private final Boolean listSuppressedAlerts;
    private final String nextToken;
    private final Integer maxResults;

    private ListActiveViolationsRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behaviorCriteriaType = builder.behaviorCriteriaType;
        this.listSuppressedAlerts = builder.listSuppressedAlerts;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String thingName() {
        return this.thingName;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public BehaviorCriteriaType behaviorCriteriaType() {
        return BehaviorCriteriaType.fromValue(this.behaviorCriteriaType);
    }

    public String behaviorCriteriaTypeAsString() {
        return this.behaviorCriteriaType;
    }

    public Boolean listSuppressedAlerts() {
        return this.listSuppressedAlerts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorCriteriaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.listSuppressedAlerts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActiveViolationsRequest)) {
            return false;
        }
        ListActiveViolationsRequest other = (ListActiveViolationsRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behaviorCriteriaTypeAsString(), other.behaviorCriteriaTypeAsString()) && Objects.equals(this.listSuppressedAlerts(), other.listSuppressedAlerts()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListActiveViolationsRequest").add("ThingName", (Object)this.thingName()).add("SecurityProfileName", (Object)this.securityProfileName()).add("BehaviorCriteriaType", (Object)this.behaviorCriteriaTypeAsString()).add("ListSuppressedAlerts", (Object)this.listSuppressedAlerts()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behaviorCriteriaType": {
                return Optional.ofNullable(clazz.cast(this.behaviorCriteriaTypeAsString()));
            }
            case "listSuppressedAlerts": {
                return Optional.ofNullable(clazz.cast(this.listSuppressedAlerts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActiveViolationsRequest, T> g) {
        return obj -> g.apply((ListActiveViolationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String securityProfileName;
        private String behaviorCriteriaType;
        private Boolean listSuppressedAlerts;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActiveViolationsRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.securityProfileName(model.securityProfileName);
            this.behaviorCriteriaType(model.behaviorCriteriaType);
            this.listSuppressedAlerts(model.listSuppressedAlerts);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getBehaviorCriteriaType() {
            return this.behaviorCriteriaType;
        }

        @Override
        public final Builder behaviorCriteriaType(String behaviorCriteriaType) {
            this.behaviorCriteriaType = behaviorCriteriaType;
            return this;
        }

        @Override
        public final Builder behaviorCriteriaType(BehaviorCriteriaType behaviorCriteriaType) {
            this.behaviorCriteriaType(behaviorCriteriaType == null ? null : behaviorCriteriaType.toString());
            return this;
        }

        public final void setBehaviorCriteriaType(String behaviorCriteriaType) {
            this.behaviorCriteriaType = behaviorCriteriaType;
        }

        public final Boolean getListSuppressedAlerts() {
            return this.listSuppressedAlerts;
        }

        @Override
        public final Builder listSuppressedAlerts(Boolean listSuppressedAlerts) {
            this.listSuppressedAlerts = listSuppressedAlerts;
            return this;
        }

        public final void setListSuppressedAlerts(Boolean listSuppressedAlerts) {
            this.listSuppressedAlerts = listSuppressedAlerts;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActiveViolationsRequest build() {
            return new ListActiveViolationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActiveViolationsRequest> {
        public Builder thingName(String var1);

        public Builder securityProfileName(String var1);

        public Builder behaviorCriteriaType(String var1);

        public Builder behaviorCriteriaType(BehaviorCriteriaType var1);

        public Builder listSuppressedAlerts(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

