/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.services.iot.model.ResourceType;
import software.amazon.awssdk.services.iot.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedResource> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(RelatedResource.getter(RelatedResource::resourceTypeAsString)).setter(RelatedResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIdentifier").getter(RelatedResource.getter(RelatedResource::resourceIdentifier)).setter(RelatedResource.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(RelatedResource.getter(RelatedResource::additionalInfo)).setter(RelatedResource.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_IDENTIFIER_FIELD, ADDITIONAL_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final ResourceIdentifier resourceIdentifier;
    private final Map<String, String> additionalInfo;

    private RelatedResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.additionalInfo = builder.additionalInfo;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public Map<String, String> additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedResource)) {
            return false;
        }
        RelatedResource other = (RelatedResource)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public String toString() {
        return ToString.builder((String)"RelatedResource").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedResource, T> g) {
        return obj -> g.apply((RelatedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private ResourceIdentifier resourceIdentifier;
        private Map<String, String> additionalInfo = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedResource model) {
            this.resourceType(model.resourceType);
            this.resourceIdentifier(model.resourceIdentifier);
            this.additionalInfo(model.additionalInfo);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        public final Map<String, String> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
            return this;
        }

        public final void setAdditionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
        }

        public RelatedResource build() {
            return new RelatedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedResource> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder additionalInfo(Map<String, String> var1);
    }
}

