/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthInfo;
import software.amazon.awssdk.services.iot.model.AuthInfosCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestAuthorizationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, TestAuthorizationRequest> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::principal)).setter(TestAuthorizationRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cognitoIdentityPoolId").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::cognitoIdentityPoolId)).setter(TestAuthorizationRequest.setter(Builder::cognitoIdentityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build()}).build();
    private static final SdkField<List<AuthInfo>> AUTH_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authInfos").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::authInfos)).setter(TestAuthorizationRequest.setter(Builder::authInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::clientId)).setter(TestAuthorizationRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientId").build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyNamesToAdd").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::policyNamesToAdd)).setter(TestAuthorizationRequest.setter(Builder::policyNamesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyNamesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_TO_SKIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyNamesToSkip").getter(TestAuthorizationRequest.getter(TestAuthorizationRequest::policyNamesToSkip)).setter(TestAuthorizationRequest.setter(Builder::policyNamesToSkip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyNamesToSkip").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, COGNITO_IDENTITY_POOL_ID_FIELD, AUTH_INFOS_FIELD, CLIENT_ID_FIELD, POLICY_NAMES_TO_ADD_FIELD, POLICY_NAMES_TO_SKIP_FIELD));
    private final String principal;
    private final String cognitoIdentityPoolId;
    private final List<AuthInfo> authInfos;
    private final String clientId;
    private final List<String> policyNamesToAdd;
    private final List<String> policyNamesToSkip;

    private TestAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.authInfos = builder.authInfos;
        this.clientId = builder.clientId;
        this.policyNamesToAdd = builder.policyNamesToAdd;
        this.policyNamesToSkip = builder.policyNamesToSkip;
    }

    public String principal() {
        return this.principal;
    }

    public String cognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public boolean hasAuthInfos() {
        return this.authInfos != null && !(this.authInfos instanceof SdkAutoConstructList);
    }

    public List<AuthInfo> authInfos() {
        return this.authInfos;
    }

    public String clientId() {
        return this.clientId;
    }

    public boolean hasPolicyNamesToAdd() {
        return this.policyNamesToAdd != null && !(this.policyNamesToAdd instanceof SdkAutoConstructList);
    }

    public List<String> policyNamesToAdd() {
        return this.policyNamesToAdd;
    }

    public boolean hasPolicyNamesToSkip() {
        return this.policyNamesToSkip != null && !(this.policyNamesToSkip instanceof SdkAutoConstructList);
    }

    public List<String> policyNamesToSkip() {
        return this.policyNamesToSkip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthInfos() ? this.authInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyNamesToAdd() ? this.policyNamesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyNamesToSkip() ? this.policyNamesToSkip() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationRequest)) {
            return false;
        }
        TestAuthorizationRequest other = (TestAuthorizationRequest)((Object)obj);
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.cognitoIdentityPoolId(), other.cognitoIdentityPoolId()) && this.hasAuthInfos() == other.hasAuthInfos() && Objects.equals(this.authInfos(), other.authInfos()) && Objects.equals(this.clientId(), other.clientId()) && this.hasPolicyNamesToAdd() == other.hasPolicyNamesToAdd() && Objects.equals(this.policyNamesToAdd(), other.policyNamesToAdd()) && this.hasPolicyNamesToSkip() == other.hasPolicyNamesToSkip() && Objects.equals(this.policyNamesToSkip(), other.policyNamesToSkip());
    }

    public String toString() {
        return ToString.builder((String)"TestAuthorizationRequest").add("Principal", (Object)this.principal()).add("CognitoIdentityPoolId", (Object)this.cognitoIdentityPoolId()).add("AuthInfos", this.hasAuthInfos() ? this.authInfos() : null).add("ClientId", (Object)this.clientId()).add("PolicyNamesToAdd", this.hasPolicyNamesToAdd() ? this.policyNamesToAdd() : null).add("PolicyNamesToSkip", this.hasPolicyNamesToSkip() ? this.policyNamesToSkip() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "cognitoIdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityPoolId()));
            }
            case "authInfos": {
                return Optional.ofNullable(clazz.cast(this.authInfos()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "policyNamesToAdd": {
                return Optional.ofNullable(clazz.cast(this.policyNamesToAdd()));
            }
            case "policyNamesToSkip": {
                return Optional.ofNullable(clazz.cast(this.policyNamesToSkip()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAuthorizationRequest, T> g) {
        return obj -> g.apply((TestAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String principal;
        private String cognitoIdentityPoolId;
        private List<AuthInfo> authInfos = DefaultSdkAutoConstructList.getInstance();
        private String clientId;
        private List<String> policyNamesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> policyNamesToSkip = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestAuthorizationRequest model) {
            super(model);
            this.principal(model.principal);
            this.cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            this.authInfos(model.authInfos);
            this.clientId(model.clientId);
            this.policyNamesToAdd(model.policyNamesToAdd);
            this.policyNamesToSkip(model.policyNamesToSkip);
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final Collection<AuthInfo.Builder> getAuthInfos() {
            if (this.authInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authInfos != null ? (Collection)this.authInfos.stream().map(AuthInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authInfos(Collection<AuthInfo> authInfos) {
            this.authInfos = AuthInfosCopier.copy(authInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authInfos(AuthInfo ... authInfos) {
            this.authInfos(Arrays.asList(authInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authInfos(Consumer<AuthInfo.Builder> ... authInfos) {
            this.authInfos(Stream.of(authInfos).map(c -> (AuthInfo)((AuthInfo.Builder)AuthInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthInfos(Collection<AuthInfo.BuilderImpl> authInfos) {
            this.authInfos = AuthInfosCopier.copyFromBuilder(authInfos);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Collection<String> getPolicyNamesToAdd() {
            if (this.policyNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyNamesToAdd;
        }

        @Override
        public final Builder policyNamesToAdd(Collection<String> policyNamesToAdd) {
            this.policyNamesToAdd = PolicyNamesCopier.copy(policyNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNamesToAdd(String ... policyNamesToAdd) {
            this.policyNamesToAdd(Arrays.asList(policyNamesToAdd));
            return this;
        }

        public final void setPolicyNamesToAdd(Collection<String> policyNamesToAdd) {
            this.policyNamesToAdd = PolicyNamesCopier.copy(policyNamesToAdd);
        }

        public final Collection<String> getPolicyNamesToSkip() {
            if (this.policyNamesToSkip instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyNamesToSkip;
        }

        @Override
        public final Builder policyNamesToSkip(Collection<String> policyNamesToSkip) {
            this.policyNamesToSkip = PolicyNamesCopier.copy(policyNamesToSkip);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNamesToSkip(String ... policyNamesToSkip) {
            this.policyNamesToSkip(Arrays.asList(policyNamesToSkip));
            return this;
        }

        public final void setPolicyNamesToSkip(Collection<String> policyNamesToSkip) {
            this.policyNamesToSkip = PolicyNamesCopier.copy(policyNamesToSkip);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestAuthorizationRequest build() {
            return new TestAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestAuthorizationRequest> {
        public Builder principal(String var1);

        public Builder cognitoIdentityPoolId(String var1);

        public Builder authInfos(Collection<AuthInfo> var1);

        public Builder authInfos(AuthInfo ... var1);

        public Builder authInfos(Consumer<AuthInfo.Builder> ... var1);

        public Builder clientId(String var1);

        public Builder policyNamesToAdd(Collection<String> var1);

        public Builder policyNamesToAdd(String ... var1);

        public Builder policyNamesToSkip(Collection<String> var1);

        public Builder policyNamesToSkip(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

