/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingAttribute;
import software.amazon.awssdk.services.iot.model.ThingAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingsResponse> {
    private static final SdkField<List<ThingAttribute>> THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("things").getter(ListThingsResponse.getter(ListThingsResponse::things)).setter(ListThingsResponse.setter(Builder::things)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThingAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingsResponse.getter(ListThingsResponse::nextToken)).setter(ListThingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ThingAttribute> things;
    private final String nextToken;

    private ListThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public boolean hasThings() {
        return this.things != null && !(this.things instanceof SdkAutoConstructList);
    }

    public List<ThingAttribute> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThings() ? this.things() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsResponse)) {
            return false;
        }
        ListThingsResponse other = (ListThingsResponse)((Object)obj);
        return this.hasThings() == other.hasThings() && Objects.equals(this.things(), other.things()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListThingsResponse").add("Things", this.hasThings() ? this.things() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "things": {
                return Optional.ofNullable(clazz.cast(this.things()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingsResponse, T> g) {
        return obj -> g.apply((ListThingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ThingAttribute> things = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsResponse model) {
            super(model);
            this.things(model.things);
            this.nextToken(model.nextToken);
        }

        public final Collection<ThingAttribute.Builder> getThings() {
            if (this.things instanceof SdkAutoConstructList) {
                return null;
            }
            return this.things != null ? (Collection)this.things.stream().map(ThingAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingAttribute ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<ThingAttribute.Builder> ... things) {
            this.things(Stream.of(things).map(c -> (ThingAttribute)((ThingAttribute.Builder)ThingAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThings(Collection<ThingAttribute.BuilderImpl> things) {
            this.things = ThingAttributeListCopier.copyFromBuilder(things);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingsResponse build() {
            return new ListThingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingsResponse> {
        public Builder things(Collection<ThingAttribute> var1);

        public Builder things(ThingAttribute ... var1);

        public Builder things(Consumer<ThingAttribute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

