/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.LogTargetConfiguration;

public class ListV2LoggingLevelsIterable
implements SdkIterable<ListV2LoggingLevelsResponse> {
    private final IotClient client;
    private final ListV2LoggingLevelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListV2LoggingLevelsIterable(IotClient client, ListV2LoggingLevelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListV2LoggingLevelsResponseFetcher();
    }

    public Iterator<ListV2LoggingLevelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LogTargetConfiguration> logTargetConfigurations() {
        Function<ListV2LoggingLevelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logTargetConfigurations() != null) {
                return response.logTargetConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListV2LoggingLevelsResponseFetcher
    implements SyncPageFetcher<ListV2LoggingLevelsResponse> {
        private ListV2LoggingLevelsResponseFetcher() {
        }

        public boolean hasNextPage(ListV2LoggingLevelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListV2LoggingLevelsResponse nextPage(ListV2LoggingLevelsResponse previousPage) {
            if (previousPage == null) {
                return ListV2LoggingLevelsIterable.this.client.listV2LoggingLevels(ListV2LoggingLevelsIterable.this.firstRequest);
            }
            return ListV2LoggingLevelsIterable.this.client.listV2LoggingLevels((ListV2LoggingLevelsRequest)((Object)ListV2LoggingLevelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

