/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary;

public class ListProvisioningTemplateVersionsIterable
implements SdkIterable<ListProvisioningTemplateVersionsResponse> {
    private final IotClient client;
    private final ListProvisioningTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProvisioningTemplateVersionsIterable(IotClient client, ListProvisioningTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProvisioningTemplateVersionsResponseFetcher();
    }

    public Iterator<ListProvisioningTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisioningTemplateVersionSummary> versions() {
        Function<ListProvisioningTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProvisioningTemplateVersionsResponseFetcher
    implements SyncPageFetcher<ListProvisioningTemplateVersionsResponse> {
        private ListProvisioningTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProvisioningTemplateVersionsResponse nextPage(ListProvisioningTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningTemplateVersionsIterable.this.client.listProvisioningTemplateVersions(ListProvisioningTemplateVersionsIterable.this.firstRequest);
            }
            return ListProvisioningTemplateVersionsIterable.this.client.listProvisioningTemplateVersions((ListProvisioningTemplateVersionsRequest)((Object)ListProvisioningTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

