/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteJobRequest extends IotRequest implements ToCopyableBuilder<DeleteJobRequest.Builder, DeleteJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteJobRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, FORCE_FIELD));

    private final String jobId;

    private final Boolean force;

    private DeleteJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the job to be deleted.
     * </p>
     * <p>
     * After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not
     * recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.
     * </p>
     * 
     * @return The ID of the job to be deleted.</p>
     *         <p>
     *         After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is
     *         not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted
     *         job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is
     * in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.
     * </p>
     * <note>
     * <p>
     * Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job
     * information or update the job execution status. Use caution and ensure that each device executing a job which is
     * deleted is able to recover to a valid state.
     * </p>
     * </note>
     * 
     * @return (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job
     *         which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is
     *         false.</p> <note>
     *         <p>
     *         Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
     *         access job information or update the job execution status. Use caution and ensure that each device
     *         executing a job which is deleted is able to recover to a valid state.
     *         </p>
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobRequest)) {
            return false;
        }
        DeleteJobRequest other = (DeleteJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteJobRequest").add("JobId", jobId()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteJobRequest, T> g) {
        return obj -> g.apply((DeleteJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteJobRequest> {
        /**
         * <p>
         * The ID of the job to be deleted.
         * </p>
         * <p>
         * After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not
         * recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job to be deleted.</p>
         *        <p>
         *        After a job deletion is completed, you may reuse this jobId when you create a new job. However, this
         *        is not recommended, and you must ensure that your devices are not using the jobId to refer to the
         *        deleted job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which
         * is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.
         * </p>
         * <note>
         * <p>
         * Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access
         * job information or update the job execution status. Use caution and ensure that each device executing a job
         * which is deleted is able to recover to a valid state.
         * </p>
         * </note>
         * 
         * @param force
         *        (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a
         *        job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default
         *        is false.</p> <note>
         *        <p>
         *        Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
         *        access job information or update the job execution status. Use caution and ensure that each device
         *        executing a job which is deleted is able to recover to a valid state.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobRequest model) {
            super(model);
            jobId(model.jobId);
            force(model.force);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteJobRequest build() {
            return new DeleteJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
