/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectCertificateTransferRequest
extends IotRequest
implements ToCopyableBuilder<Builder, RejectCertificateTransferRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RejectCertificateTransferRequest.getter(RejectCertificateTransferRequest::certificateId)).setter(RejectCertificateTransferRequest.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateId").build()}).build();
    private static final SdkField<String> REJECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RejectCertificateTransferRequest.getter(RejectCertificateTransferRequest::rejectReason)).setter(RejectCertificateTransferRequest.setter(Builder::rejectReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, REJECT_REASON_FIELD));
    private final String certificateId;
    private final String rejectReason;

    private RejectCertificateTransferRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.rejectReason = builder.rejectReason;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String rejectReason() {
        return this.rejectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectCertificateTransferRequest)) {
            return false;
        }
        RejectCertificateTransferRequest other = (RejectCertificateTransferRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.rejectReason(), other.rejectReason());
    }

    public String toString() {
        return ToString.builder((String)"RejectCertificateTransferRequest").add("CertificateId", (Object)this.certificateId()).add("RejectReason", (Object)this.rejectReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "rejectReason": {
                return Optional.ofNullable(clazz.cast(this.rejectReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectCertificateTransferRequest, T> g) {
        return obj -> g.apply((RejectCertificateTransferRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String rejectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectCertificateTransferRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.rejectReason(model.rejectReason);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getRejectReason() {
            return this.rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectCertificateTransferRequest build() {
            return new RejectCertificateTransferRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectCertificateTransferRequest> {
        public Builder certificateId(String var1);

        public Builder rejectReason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

