/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCertificateRequest extends IotRequest implements
        ToCopyableBuilder<UpdateCertificateRequest.Builder, UpdateCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCertificateRequest::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateId").build()).build();

    private static final SdkField<String> NEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCertificateRequest::newStatusAsString)).setter(setter(Builder::newStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("newStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            NEW_STATUS_FIELD));

    private final String certificateId;

    private final String newStatus;

    private UpdateCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
    }

    /**
     * <p>
     * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     * </p>
     * 
     * @return The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The new status.
     * </p>
     * <p>
     * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown. PENDING_TRANSFER is
     * a status used internally by AWS IoT. It is not intended for developer use.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newStatus} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #newStatusAsString}.
     * </p>
     * 
     * @return The new status.</p>
     *         <p>
     *         <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
     *         PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
     *         </p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CertificateStatus
     */
    public CertificateStatus newStatus() {
        return CertificateStatus.fromValue(newStatus);
    }

    /**
     * <p>
     * The new status.
     * </p>
     * <p>
     * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown. PENDING_TRANSFER is
     * a status used internally by AWS IoT. It is not intended for developer use.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newStatus} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #newStatusAsString}.
     * </p>
     * 
     * @return The new status.</p>
     *         <p>
     *         <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
     *         PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
     *         </p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CertificateStatus
     */
    public String newStatusAsString() {
        return newStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(newStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateRequest)) {
            return false;
        }
        UpdateCertificateRequest other = (UpdateCertificateRequest) obj;
        return Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(newStatusAsString(), other.newStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCertificateRequest").add("CertificateId", certificateId())
                .add("NewStatus", newStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "newStatus":
            return Optional.ofNullable(clazz.cast(newStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateRequest, T> g) {
        return obj -> g.apply((UpdateCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCertificateRequest> {
        /**
         * <p>
         * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The new status.
         * </p>
         * <p>
         * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         * PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The new status.</p>
         *        <p>
         *        <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         *        PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         *        </p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder newStatus(String newStatus);

        /**
         * <p>
         * The new status.
         * </p>
         * <p>
         * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         * PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The new status.</p>
         *        <p>
         *        <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         *        PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         *        </p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder newStatus(CertificateStatus newStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateId;

        private String newStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateRequest model) {
            super(model);
            certificateId(model.certificateId);
            newStatus(model.newStatus);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatusAsString() {
            return newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CertificateStatus newStatus) {
            this.newStatus(newStatus == null ? null : newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateRequest build() {
            return new UpdateCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
