/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing group search index document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingGroupDocument.Builder, ThingGroupDocument> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupDocument::thingGroupName)).setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()).build();

    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupDocument::thingGroupId)).setter(setter(Builder::thingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupId").build()).build();

    private static final SdkField<String> THING_GROUP_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupDocument::thingGroupDescription)).setter(setter(Builder::thingGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupDescription").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ThingGroupDocument::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PARENT_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ThingGroupDocument::parentGroupNames))
            .setter(setter(Builder::parentGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_ID_FIELD, THING_GROUP_DESCRIPTION_FIELD, ATTRIBUTES_FIELD, PARENT_GROUP_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingGroupName;

    private final String thingGroupId;

    private final String thingGroupDescription;

    private final Map<String, String> attributes;

    private final List<String> parentGroupNames;

    private ThingGroupDocument(BuilderImpl builder) {
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.thingGroupDescription = builder.thingGroupDescription;
        this.attributes = builder.attributes;
        this.parentGroupNames = builder.parentGroupNames;
    }

    /**
     * <p>
     * The thing group name.
     * </p>
     * 
     * @return The thing group name.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group ID.
     * </p>
     * 
     * @return The thing group ID.
     */
    public String thingGroupId() {
        return thingGroupId;
    }

    /**
     * <p>
     * The thing group description.
     * </p>
     * 
     * @return The thing group description.
     */
    public String thingGroupDescription() {
        return thingGroupDescription;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The thing group attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The thing group attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * Returns true if the ParentGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasParentGroupNames() {
        return parentGroupNames != null && !(parentGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parent group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParentGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Parent group names.
     */
    public List<String> parentGroupNames() {
        return parentGroupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(parentGroupNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupDocument)) {
            return false;
        }
        ThingGroupDocument other = (ThingGroupDocument) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupId(), other.thingGroupId())
                && Objects.equals(thingGroupDescription(), other.thingGroupDescription())
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(parentGroupNames(), other.parentGroupNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingGroupDocument").add("ThingGroupName", thingGroupName()).add("ThingGroupId", thingGroupId())
                .add("ThingGroupDescription", thingGroupDescription()).add("Attributes", attributes())
                .add("ParentGroupNames", parentGroupNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        case "thingGroupDescription":
            return Optional.ofNullable(clazz.cast(thingGroupDescription()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "parentGroupNames":
            return Optional.ofNullable(clazz.cast(parentGroupNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupDocument, T> g) {
        return obj -> g.apply((ThingGroupDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingGroupDocument> {
        /**
         * <p>
         * The thing group name.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);

        /**
         * <p>
         * The thing group description.
         * </p>
         * 
         * @param thingGroupDescription
         *        The thing group description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupDescription(String thingGroupDescription);

        /**
         * <p>
         * The thing group attributes.
         * </p>
         * 
         * @param attributes
         *        The thing group attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Parent group names.
         * </p>
         * 
         * @param parentGroupNames
         *        Parent group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupNames(Collection<String> parentGroupNames);

        /**
         * <p>
         * Parent group names.
         * </p>
         * 
         * @param parentGroupNames
         *        Parent group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupNames(String... parentGroupNames);
    }

    static final class BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupId;

        private String thingGroupDescription;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private List<String> parentGroupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupDocument model) {
            thingGroupName(model.thingGroupName);
            thingGroupId(model.thingGroupId);
            thingGroupDescription(model.thingGroupDescription);
            attributes(model.attributes);
            parentGroupNames(model.parentGroupNames);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        public final String getThingGroupDescription() {
            return thingGroupDescription;
        }

        @Override
        public final Builder thingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
            return this;
        }

        public final void setThingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Collection<String> getParentGroupNames() {
            return parentGroupNames;
        }

        @Override
        public final Builder parentGroupNames(Collection<String> parentGroupNames) {
            this.parentGroupNames = ThingGroupNameListCopier.copy(parentGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentGroupNames(String... parentGroupNames) {
            parentGroupNames(Arrays.asList(parentGroupNames));
            return this;
        }

        public final void setParentGroupNames(Collection<String> parentGroupNames) {
            this.parentGroupNames = ThingGroupNameListCopier.copy(parentGroupNames);
        }

        @Override
        public ThingGroupDocument build() {
            return new ThingGroupDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
