/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelJobExecutionRequest extends IotRequest implements
        ToCopyableBuilder<CancelJobExecutionRequest.Builder, CancelJobExecutionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelJobExecutionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelJobExecutionRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CancelJobExecutionRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CancelJobExecutionRequest::expectedVersion)).setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()).build();

    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CancelJobExecutionRequest::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            THING_NAME_FIELD, FORCE_FIELD, EXPECTED_VERSION_FIELD, STATUS_DETAILS_FIELD));

    private final String jobId;

    private final String thingName;

    private final Boolean force;

    private final Long expectedVersion;

    private final Map<String, String> statusDetails;

    private CancelJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.force = builder.force;
        this.expectedVersion = builder.expectedVersion;
        this.statusDetails = builder.statusDetails;
    }

    /**
     * <p>
     * The ID of the job to be canceled.
     * </p>
     * 
     * @return The ID of the job to be canceled.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the thing whose execution of the job will be canceled.
     * </p>
     * 
     * @return The name of the thing whose execution of the job will be canceled.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * (Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED,
     * otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job
     * execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an
     * <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.
     * </p>
     * <p>
     * Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution
     * status. Use caution and ensure that the device is able to recover to a valid state.
     * </p>
     * 
     * @return (Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or
     *         QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to
     *         cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>,
     *         then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>
     *         .</p>
     *         <p>
     *         Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job
     *         execution status. Use caution and ensure that the device is able to recover to a valid state.
     */
    public Boolean force() {
        return force;
    }

    /**
     * <p>
     * (Optional) The expected current version of the job execution. Each time you update the job execution, its version
     * is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a
     * VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned.
     * (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job
     * execution status data.)
     * </p>
     * 
     * @return (Optional) The expected current version of the job execution. Each time you update the job execution, its
     *         version is incremented. If the version of the job execution stored in Jobs does not match, the update is
     *         rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution
     *         status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in
     *         order to obtain the job execution status data.)
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * Returns true if the StatusDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStatusDetails() {
        return statusDetails != null && !(statusDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of name/value pairs that describe the status of the job execution. If not specified, the
     * statusDetails are unchanged. You can specify at most 10 name/value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatusDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of name/value pairs that describe the status of the job execution. If not specified, the
     *         statusDetails are unchanged. You can specify at most 10 name/value pairs.
     */
    public Map<String, String> statusDetails() {
        return statusDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobExecutionRequest)) {
            return false;
        }
        CancelJobExecutionRequest other = (CancelJobExecutionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(force(), other.force()) && Objects.equals(expectedVersion(), other.expectedVersion())
                && Objects.equals(statusDetails(), other.statusDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelJobExecutionRequest").add("JobId", jobId()).add("ThingName", thingName())
                .add("Force", force()).add("ExpectedVersion", expectedVersion()).add("StatusDetails", statusDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelJobExecutionRequest, T> g) {
        return obj -> g.apply((CancelJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelJobExecutionRequest> {
        /**
         * <p>
         * The ID of the job to be canceled.
         * </p>
         * 
         * @param jobId
         *        The ID of the job to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the thing whose execution of the job will be canceled.
         * </p>
         * 
         * @param thingName
         *        The name of the thing whose execution of the job will be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * (Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED,
         * otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job
         * execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an
         * <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.
         * </p>
         * <p>
         * Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job
         * execution status. Use caution and ensure that the device is able to recover to a valid state.
         * </p>
         * 
         * @param force
         *        (Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or
         *        QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to
         *        cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>
         *        , then an <code>InvalidStateTransitionException</code> will be thrown. The default is
         *        <code>false</code>.</p>
         *        <p>
         *        Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job
         *        execution status. Use caution and ensure that the device is able to recover to a valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * (Optional) The expected current version of the job execution. Each time you update the job execution, its
         * version is incremented. If the version of the job execution stored in Jobs does not match, the update is
         * rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status
         * data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to
         * obtain the job execution status data.)
         * </p>
         * 
         * @param expectedVersion
         *        (Optional) The expected current version of the job execution. Each time you update the job execution,
         *        its version is incremented. If the version of the job execution stored in Jobs does not match, the
         *        update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job
         *        execution status data is returned. (This makes it unnecessary to perform a separate
         *        DescribeJobExecution request in order to obtain the job execution status data.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * A collection of name/value pairs that describe the status of the job execution. If not specified, the
         * statusDetails are unchanged. You can specify at most 10 name/value pairs.
         * </p>
         * 
         * @param statusDetails
         *        A collection of name/value pairs that describe the status of the job execution. If not specified, the
         *        statusDetails are unchanged. You can specify at most 10 name/value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(Map<String, String> statusDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String thingName;

        private Boolean force;

        private Long expectedVersion;

        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobExecutionRequest model) {
            super(model);
            jobId(model.jobId);
            thingName(model.thingName);
            force(model.force);
            expectedVersion(model.expectedVersion);
            statusDetails(model.statusDetails);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Map<String, String> getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelJobExecutionRequest build() {
            return new CancelJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
